/*
 * Decompiled with CFR 0.152.
 */
package moe.wolfgirl.powerfuljs.serde;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.OptionalInt;
import java.util.function.Supplier;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;

public record ItemContent(List<ItemStack> items) {
    public static final Supplier<ItemContent> EMPTY = () -> new ItemContent((List<ItemStack>)NonNullList.create());
    public static final Codec<ItemContent> CODEC = Slot.CODEC.listOf().xmap(ItemContent::fromSlots, ItemContent::asSlots);
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemContent> STREAM_CODEC = ItemStack.OPTIONAL_STREAM_CODEC.apply(ByteBufCodecs.list()).map(ItemContent::new, content -> content.items);

    public ItemStack getStackInSlot(int slot) {
        return slot < this.items.size() ? this.items.get(slot) : ItemStack.EMPTY;
    }

    public ItemContent withStackInSlot(int slot, ItemStack itemStack) {
        NonNullList newContent = NonNullList.withSize((int)Math.max(slot + 1, this.items.size()), (Object)ItemStack.EMPTY);
        for (int i = 0; i < this.items.size(); ++i) {
            newContent.set(i, (Object)(i == slot ? itemStack : this.items.get(i)).copy());
        }
        return new ItemContent((List<ItemStack>)newContent);
    }

    private static ItemContent fromSlots(List<Slot> slots) {
        OptionalInt maxIndex = slots.stream().mapToInt(Slot::index).max();
        if (maxIndex.isEmpty()) {
            return EMPTY.get();
        }
        ItemContent itemContent = new ItemContent((List<ItemStack>)NonNullList.withSize((int)(maxIndex.getAsInt() + 1), (Object)ItemStack.EMPTY));
        for (Slot slot : slots) {
            itemContent.items.set(slot.index, slot.content);
        }
        return itemContent;
    }

    private List<Slot> asSlots() {
        ArrayList<Slot> slots = new ArrayList<Slot>();
        for (int i = 0; i < this.items.size(); ++i) {
            ItemStack content = this.items.get(i);
            if (content.isEmpty()) continue;
            slots.add(new Slot(i, content));
        }
        return slots;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        List<ItemStack> items1;
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ItemContent)) return false;
        ItemContent itemContent = (ItemContent)obj;
        try {
            List<ItemStack> list;
            items1 = list = itemContent.items();
            if (items1 == null || items1.size() != this.items.size()) return false;
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        for (int i = 0; i < this.items.size(); ++i) {
            if (ItemStack.isSameItemSameComponents((ItemStack)this.items.get(i), (ItemStack)items1.get(i))) continue;
            return false;
        }
        return true;
    }

    record Slot(int index, ItemStack content) {
        public static final Codec<Slot> CODEC = RecordCodecBuilder.create(slot -> slot.group((App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("slot").forGetter(Slot::index), (App)ItemStack.CODEC.fieldOf("item").forGetter(Slot::content)).apply((Applicative)slot, Slot::new));
    }
}

