/*
 * Decompiled with CFR 0.152.
 */
package moe.wolfgirl.powerfuljs.serde;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;

public record ChunkDataStorage(Map<BlockPos, CompoundTag> data) {
    private static final Codec<Pair<BlockPos, CompoundTag>> DATA_CODEC = RecordCodecBuilder.create(data -> data.group((App)BlockPos.CODEC.fieldOf("pos").forGetter(Pair::getFirst), (App)CompoundTag.CODEC.fieldOf("data").forGetter(Pair::getSecond)).apply((Applicative)data, Pair::new));
    public static final Codec<ChunkDataStorage> CODEC = DATA_CODEC.listOf().xmap(ChunkDataStorage::to, ChunkDataStorage::from);

    public static ChunkDataStorage newEmpty() {
        return new ChunkDataStorage(new HashMap<BlockPos, CompoundTag>());
    }

    private static ChunkDataStorage to(List<Pair<BlockPos, CompoundTag>> dataList) {
        HashMap<BlockPos, CompoundTag> data = new HashMap<BlockPos, CompoundTag>();
        for (Pair<BlockPos, CompoundTag> pair : dataList) {
            if (((CompoundTag)pair.getSecond()).isEmpty()) continue;
            data.put((BlockPos)pair.getFirst(), (CompoundTag)pair.getSecond());
        }
        return new ChunkDataStorage(data);
    }

    private List<Pair<BlockPos, CompoundTag>> from() {
        ArrayList<Pair<BlockPos, CompoundTag>> dataList = new ArrayList<Pair<BlockPos, CompoundTag>>();
        for (Map.Entry<BlockPos, CompoundTag> entry : this.data.entrySet()) {
            BlockPos blockPos = entry.getKey();
            CompoundTag compoundTag = entry.getValue();
            dataList.add((Pair<BlockPos, CompoundTag>)new Pair((Object)blockPos, (Object)compoundTag));
        }
        return dataList;
    }
}

