/*
 * Decompiled with CFR 0.152.
 */
package moe.wolfgirl.powerfuljs.plugins.docs;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import moe.wolfgirl.powerfuljs.custom.base.CapabilityBuilder;
import moe.wolfgirl.powerfuljs.custom.registries.BlockCapabilityRegistry;
import moe.wolfgirl.powerfuljs.custom.registries.EntityCapabilityRegistry;
import moe.wolfgirl.powerfuljs.custom.registries.ItemCapabilityRegistry;
import moe.wolfgirl.powerfuljs.events.PowerfulRegisterCapabilitiesEvent;
import moe.wolfgirl.probejs.lang.java.clazz.ClassPath;
import moe.wolfgirl.probejs.lang.transpiler.TypeConverter;
import moe.wolfgirl.probejs.lang.typescript.ScriptDump;
import moe.wolfgirl.probejs.lang.typescript.TypeScriptFile;
import moe.wolfgirl.probejs.lang.typescript.code.Code;
import moe.wolfgirl.probejs.lang.typescript.code.member.ClassDecl;
import moe.wolfgirl.probejs.lang.typescript.code.member.MethodDecl;
import moe.wolfgirl.probejs.lang.typescript.code.member.ParamDecl;
import moe.wolfgirl.probejs.lang.typescript.code.member.TypeDecl;
import moe.wolfgirl.probejs.lang.typescript.code.type.BaseType;
import moe.wolfgirl.probejs.lang.typescript.code.type.Types;
import moe.wolfgirl.probejs.lang.typescript.code.type.js.JSObjectType;
import moe.wolfgirl.probejs.plugin.ProbeJSPlugin;
import net.minecraft.resources.ResourceLocation;

public class RegisterCapabilityEvent
extends ProbeJSPlugin {
    public void modifyClasses(ScriptDump scriptDump, Map<ClassPath, TypeScriptFile> globalClasses) {
        TypeConverter converter = scriptDump.transpiler.typeConverter;
        TypeScriptFile scriptFile = globalClasses.get(new ClassPath(PowerfulRegisterCapabilitiesEvent.class));
        if (scriptFile == null) {
            return;
        }
        this.generateMappedTypes("BlockEntityCapabilityMap", "BlockEntityCapabilities", BlockCapabilityRegistry.BLOCK_ENTITIES, converter, scriptFile);
        this.generateMappedTypes("BlockCapabilityMap", "BlockCapabilities", BlockCapabilityRegistry.BLOCKS, converter, scriptFile);
        this.generateMappedTypes("EntityCapabilityMap", "EntityCapabilities", EntityCapabilityRegistry.ENTITY, converter, scriptFile);
        this.generateMappedTypes("ItemCapabilityMap", "ItemCapabilities", ItemCapabilityRegistry.ITEM, converter, scriptFile);
        ClassDecl classDecl = (ClassDecl)scriptFile.findCode(ClassDecl.class).orElseThrow();
        for (MethodDecl method : classDecl.methods) {
            if (method.name.equals("registerBlock")) {
                this.patchMethod(method, "BlockCapabilities", "BlockCapabilityMap");
            }
            if (method.name.equals("registerBlockEntity")) {
                this.patchMethod(method, "BlockEntityCapabilities", "BlockEntityCapabilityMap");
            }
            if (method.name.equals("registerItem")) {
                this.patchMethod(method, "ItemCapabilities", "ItemCapabilityMap");
            }
            if (!method.name.equals("registerEntity")) continue;
            this.patchMethod(method, "EntityCapabilities", "EntityCapabilityMap");
        }
    }

    private <O> void generateMappedTypes(String mapName, String flagName, Map<ResourceLocation, CapabilityBuilder<O, ?>> registry, TypeConverter converter, TypeScriptFile typeScriptFile) {
        JSObjectType.Builder typeDict = Types.object();
        for (Map.Entry<ResourceLocation, CapabilityBuilder<O, ?>> entry : registry.entrySet()) {
            ResourceLocation key = entry.getKey();
            CapabilityBuilder<O, ?> builder = entry.getValue();
            typeDict.member(key.toString(), converter.convertType(builder.typeInfo()));
        }
        typeScriptFile.addCode((Code)new TypeDecl(mapName, (BaseType)typeDict.buildIndexed()));
        typeScriptFile.addCode((Code)new TypeDecl(flagName, (BaseType)Types.primitive((String)"keyof %s".formatted(mapName))));
    }

    private void patchMethod(MethodDecl methodDecl, String flagName, String mapName) {
        methodDecl.variableTypes.add(Types.generic((String)"T", (BaseType)Types.primitive((String)flagName)));
        methodDecl.params.set(0, new ParamDecl("builderKey", (BaseType)Types.generic((String)"T"), false, false));
        methodDecl.params.set(1, new ParamDecl("configuration", (BaseType)Types.primitive((String)"%s[T]".formatted(mapName)), false, false));
    }

    private <O> void addBuilderClasses(Map<ResourceLocation, CapabilityBuilder<O, ?>> builders, Set<Class<?>> allClass) {
        for (CapabilityBuilder<O, ?> value : builders.values()) {
            allClass.add(value.typeInfo().asClass());
        }
    }

    public Set<Class<?>> provideJavaClass(ScriptDump scriptDump) {
        HashSet classes = new HashSet();
        this.addBuilderClasses(BlockCapabilityRegistry.BLOCK_ENTITIES, classes);
        this.addBuilderClasses(BlockCapabilityRegistry.BLOCKS, classes);
        this.addBuilderClasses(ItemCapabilityRegistry.ITEM, classes);
        this.addBuilderClasses(EntityCapabilityRegistry.ENTITY, classes);
        return classes;
    }
}

