/*
 * Decompiled with CFR 0.152.
 */
package moe.wolfgirl.powerfuljs.plugins.docs;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import moe.wolfgirl.powerfuljs.custom.CapabilityJS;
import moe.wolfgirl.powerfuljs.custom.CapabilityWrapper;
import moe.wolfgirl.probejs.lang.java.clazz.ClassPath;
import moe.wolfgirl.probejs.lang.typescript.ScriptDump;
import moe.wolfgirl.probejs.lang.typescript.TypeScriptFile;
import moe.wolfgirl.probejs.lang.typescript.code.Code;
import moe.wolfgirl.probejs.lang.typescript.code.member.InterfaceDecl;
import moe.wolfgirl.probejs.lang.typescript.code.member.MethodDecl;
import moe.wolfgirl.probejs.lang.typescript.code.member.ParamDecl;
import moe.wolfgirl.probejs.lang.typescript.code.member.TypeDecl;
import moe.wolfgirl.probejs.lang.typescript.code.type.BaseType;
import moe.wolfgirl.probejs.lang.typescript.code.type.TSClassType;
import moe.wolfgirl.probejs.lang.typescript.code.type.Types;
import moe.wolfgirl.probejs.lang.typescript.code.type.js.JSObjectType;
import moe.wolfgirl.probejs.plugin.ProbeJSPlugin;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.capabilities.BaseCapability;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.EntityCapability;
import net.neoforged.neoforge.capabilities.ItemCapability;

public class CapabilityJSDoc
extends ProbeJSPlugin {
    public void modifyClasses(ScriptDump scriptDump, Map<ClassPath, TypeScriptFile> globalClasses) {
        TypeScriptFile scriptFile = globalClasses.get(new ClassPath(CapabilityWrapper.class));
        if (scriptFile == null) {
            return;
        }
        this.generateMappedTypes("BlockCapabilityMap", "BlockCapabilities", CapabilityJS.BLOCK, BlockCapability.class, scriptFile);
        this.generateMappedTypes("EntityCapabilityMap", "EntityCapabilities", CapabilityJS.ENTITY, EntityCapability.class, scriptFile);
        this.generateMappedTypes("ItemCapabilityMap", "ItemCapabilities", CapabilityJS.ITEM, ItemCapability.class, scriptFile);
        InterfaceDecl classDecl = (InterfaceDecl)scriptFile.findCode(InterfaceDecl.class).orElseThrow();
        for (MethodDecl method : classDecl.methods) {
            if (method.name.equals("item")) {
                this.patchMethod(method, "ItemCapabilities", "ItemCapabilityMap");
            }
            if (method.name.equals("block")) {
                this.patchMethod(method, "BlockCapabilities", "BlockCapabilityMap");
            }
            if (!method.name.equals("entity")) continue;
            this.patchMethod(method, "EntityCapabilities", "EntityCapabilityMap");
        }
    }

    private void patchMethod(MethodDecl methodDecl, String flagName, String mapName) {
        methodDecl.variableTypes.add(Types.generic((String)"T", (BaseType)Types.primitive((String)flagName)));
        methodDecl.params.set(0, new ParamDecl("capability", (BaseType)Types.generic((String)"T"), false, false));
        methodDecl.returnType = Types.primitive((String)"%s[T]".formatted(mapName));
    }

    private <O extends BaseCapability<?, ?>> void addCapabilityClasses(CapabilityJS<O> capabilityJS, Set<Class<?>> allClass) {
        capabilityJS.getCapabilities().forEach(o -> {
            if (o.contextClass() != Void.TYPE) {
                allClass.add(o.contextClass());
            }
            allClass.add(o.typeClass());
        });
    }

    public Set<Class<?>> provideJavaClass(ScriptDump scriptDump) {
        HashSet classes = new HashSet();
        this.addCapabilityClasses(CapabilityJS.BLOCK, classes);
        this.addCapabilityClasses(CapabilityJS.ENTITY, classes);
        this.addCapabilityClasses(CapabilityJS.ITEM, classes);
        return classes;
    }

    private <O extends BaseCapability<?, ?>> void generateMappedTypes(String mapName, String flagName, CapabilityJS<O> capabilityJS, Class<?> capClass, TypeScriptFile typeScriptFile) {
        JSObjectType.Builder typeDict = Types.object();
        TSClassType capType = Types.type(capClass);
        capabilityJS.getCapabilities().forEach(arg_0 -> CapabilityJSDoc.lambda$generateMappedTypes$1(typeDict, (BaseType)capType, arg_0));
        typeScriptFile.addCode((Code)new TypeDecl(mapName, (BaseType)typeDict.buildIndexed()));
        typeScriptFile.addCode((Code)new TypeDecl(flagName, (BaseType)Types.primitive((String)"keyof %s".formatted(mapName))));
    }

    private static /* synthetic */ void lambda$generateMappedTypes$1(JSObjectType.Builder typeDict, BaseType capType, BaseCapability cap) {
        ResourceLocation key = cap.name();
        Class typeClass = cap.typeClass();
        Class contextClass = cap.contextClass();
        typeDict.member(key.toString(), Types.ignoreContext((BaseType)Types.parameterized((BaseType)capType, (BaseType[])new BaseType[]{Types.type((Class)typeClass), contextClass == Void.TYPE ? Types.VOID : Types.type((Class)contextClass)}), (BaseType.FormatType)BaseType.FormatType.RETURN));
    }
}

