/*
 * Decompiled with CFR 0.152.
 */
package moe.wolfgirl.powerfuljs.mixin.minecraft;

import dev.latvian.mods.kubejs.util.Cast;
import moe.wolfgirl.powerfuljs.custom.logic.behavior.ProgressProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={SpawnerBlockEntity.class})
public class SpawnerMixin
implements ProgressProvider {
    @Shadow
    @Final
    private BaseSpawner spawner;

    @Unique
    private BlockEntity pjs$self() {
        return (BlockEntity)Cast.to((Object)this);
    }

    @Override
    public int pjs$getProgress() {
        return 0;
    }

    @Override
    public int pjs$getMaxProgress() {
        return this.spawner.spawnDelay;
    }

    @Override
    public void pjs$setProgress(int progress) {
        this.spawner.spawnDelay = Math.max(0, this.pjs$getMaxProgress() - progress);
    }

    @Override
    public boolean pjs$running() {
        BlockEntity self = this.pjs$self();
        Level level = self.getLevel();
        if (level == null) {
            return false;
        }
        BlockPos pos = self.getBlockPos();
        return level.hasNearbyAlivePlayer((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 16.0);
    }

    @Override
    public void pjs$addProgress(int progress) {
        this.spawner.spawnDelay = Math.max(0, this.spawner.spawnDelay - progress);
    }

    @Override
    public void pjs$clearProgress() {
        Level level = this.pjs$self().getLevel();
        if (level == null) {
            return;
        }
        this.spawner.spawnDelay = this.spawner.minSpawnDelay + level.random.nextInt(this.spawner.maxSpawnDelay);
    }
}

