/*
 * Decompiled with CFR 0.152.
 */
package moe.wolfgirl.powerfuljs.mixin.create;

import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.content.fluids.spout.SpoutBlockEntity;
import com.simibubi.create.content.fluids.transfer.FillingRecipe;
import com.simibubi.create.content.kinetics.belt.BeltBlockEntity;
import com.simibubi.create.content.logistics.depot.DepotBlockEntity;
import java.util.List;
import moe.wolfgirl.powerfuljs.custom.logic.behavior.EqualityCache;
import moe.wolfgirl.powerfuljs.custom.logic.behavior.ProgressProvider;
import moe.wolfgirl.powerfuljs.custom.logic.behavior.RecipeProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={SpoutBlockEntity.class})
public abstract class SpoutMixin
implements RecipeProvider,
ProgressProvider {
    @Shadow
    public int processingTicks;
    @Unique
    private EqualityCache.KeyAccessible<List<ItemStack>, ResourceLocation> pjs$cache = null;

    @Shadow
    protected abstract FluidStack getCurrentFluidInTank();

    @Override
    public int pjs$getProgress() {
        return 20 - this.processingTicks;
    }

    @Override
    public int pjs$getMaxProgress() {
        return 20;
    }

    @Override
    public void pjs$setProgress(int progress) {
        this.processingTicks = Math.max(-1, 20 - progress);
        this.pjs$self().notifyUpdate();
    }

    @Override
    public boolean pjs$running() {
        return this.processingTicks != -1;
    }

    @Unique
    private SpoutBlockEntity pjs$self() {
        return (SpoutBlockEntity)this;
    }

    @Unique
    private List<ItemStack> pjs$getItem() {
        BlockPos pos;
        Level level = this.pjs$self().getLevel();
        BlockEntity be = level.getBlockEntity((pos = this.pjs$self().getBlockPos()).below(2));
        if (be instanceof BeltBlockEntity) {
            BeltBlockEntity beltBlockEntity = (BeltBlockEntity)be;
            return beltBlockEntity.getInventory().getTransportedItems().stream().map(t -> t.stack).toList();
        }
        if (be instanceof DepotBlockEntity) {
            DepotBlockEntity depotBlockEntity = (DepotBlockEntity)be;
            return List.of(depotBlockEntity.getHeldItem());
        }
        return List.of();
    }

    @Override
    @Nullable
    public ResourceLocation pjs$getRunningRecipe() {
        if (this.processingTicks == -1) {
            return null;
        }
        if (this.pjs$cache == null) {
            this.pjs$cache = new EqualityCache.KeyAccessible<List, ResourceLocation>(this::pjs$getItem, itemStacks -> {
                Level level = this.pjs$self().getLevel();
                for (ItemStack item : itemStacks) {
                    for (RecipeHolder holder : level.getRecipeManager().getRecipesFor(AllRecipeTypes.FILLING.getType(), (RecipeInput)new SingleRecipeInput(item.copyWithCount(1)), level)) {
                        FillingRecipe fillingRecipe = (FillingRecipe)holder.value();
                        if (!fillingRecipe.getRequiredFluid().test(this.getCurrentFluidInTank())) continue;
                        return holder.id();
                    }
                }
                return null;
            });
        }
        return this.pjs$cache.get();
    }
}

