/*
 * Decompiled with CFR 0.152.
 */
package moe.wolfgirl.powerfuljs.mixin.create;

import com.simibubi.create.content.kinetics.belt.BeltBlockEntity;
import com.simibubi.create.content.kinetics.press.MechanicalPressBlockEntity;
import com.simibubi.create.content.kinetics.press.PressingBehaviour;
import com.simibubi.create.content.kinetics.press.PressingRecipe;
import com.simibubi.create.content.logistics.depot.DepotBlockEntity;
import java.util.List;
import java.util.Optional;
import moe.wolfgirl.powerfuljs.custom.logic.behavior.IdentityCache;
import moe.wolfgirl.powerfuljs.custom.logic.behavior.ProgressProvider;
import moe.wolfgirl.powerfuljs.custom.logic.behavior.RecipeProvider;
import moe.wolfgirl.powerfuljs.custom.mods.create.BasinRecipeProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={MechanicalPressBlockEntity.class})
public abstract class MechanicalPressMixin
implements RecipeProvider,
ProgressProvider {
    @Unique
    private IdentityCache.KeyAccessible<ItemStack, ResourceLocation> pjs$cache = null;
    @Shadow
    public PressingBehaviour pressingBehaviour;

    @Shadow
    public abstract Optional<RecipeHolder<PressingRecipe>> getRecipe(ItemStack var1);

    @Override
    public int pjs$getProgress() {
        return this.pressingBehaviour.runningTicks;
    }

    @Override
    public int pjs$getMaxProgress() {
        return 241;
    }

    @Override
    public void pjs$setProgress(int progress) {
        this.pressingBehaviour.runningTicks = Math.min(progress, 241);
        this.pjs$self().notifyUpdate();
    }

    @Override
    public boolean pjs$running() {
        return this.pressingBehaviour.running;
    }

    @Unique
    private MechanicalPressBlockEntity pjs$self() {
        return (MechanicalPressBlockEntity)this;
    }

    @Unique
    private List<ItemStack> pjs$getItem() {
        BlockPos pos;
        Level level = this.pjs$self().getLevel();
        BlockEntity be = level.getBlockEntity((pos = this.pjs$self().getBlockPos()).below(2));
        if (be instanceof BeltBlockEntity) {
            BeltBlockEntity beltBlockEntity = (BeltBlockEntity)be;
            return beltBlockEntity.getInventory().getTransportedItems().stream().map(t -> t.stack).toList();
        }
        if (be instanceof DepotBlockEntity) {
            DepotBlockEntity depotBlockEntity = (DepotBlockEntity)be;
            return List.of(depotBlockEntity.getHeldItem());
        }
        return List.of();
    }

    @Override
    @Nullable
    public ResourceLocation pjs$getRunningRecipe() {
        if (!this.pressingBehaviour.running) {
            return null;
        }
        Level level = this.pjs$self().getLevel();
        BlockPos pos = this.pjs$self().getBlockPos();
        if (this.pressingBehaviour.mode == PressingBehaviour.Mode.BASIN) {
            ResourceLocation resourceLocation;
            MechanicalPressMixin mechanicalPressMixin = this;
            if (mechanicalPressMixin instanceof BasinRecipeProvider) {
                BasinRecipeProvider brp = (BasinRecipeProvider)((Object)mechanicalPressMixin);
                resourceLocation = brp.pjs$getBasinRunningRecipe();
            } else {
                resourceLocation = null;
            }
            return resourceLocation;
        }
        if (this.pjs$cache == null) {
            this.pjs$cache = new IdentityCache.KeyAccessible<ItemStack, ResourceLocation>(() -> switch (this.pressingBehaviour.mode) {
                default -> throw new MatchException(null, null);
                case PressingBehaviour.Mode.WORLD -> {
                    AABB bb = new AABB(pos.below(1));
                    for (Entity entity : level.getEntities(null, bb)) {
                        if (!(entity instanceof ItemEntity)) continue;
                        ItemEntity item = (ItemEntity)entity;
                        yield item.getItem();
                    }
                    yield ItemStack.EMPTY;
                }
                case PressingBehaviour.Mode.BELT -> {
                    List<ItemStack> items = this.pjs$getItem();
                    if (items.isEmpty()) {
                        yield ItemStack.EMPTY;
                    }
                    yield items.getFirst();
                }
                case PressingBehaviour.Mode.BASIN -> ItemStack.EMPTY;
            }, itemStack -> this.getRecipe(itemStack.copyWithCount(1)).map(RecipeHolder::id).orElse(null));
        }
        return this.pjs$cache.get();
    }
}

