/*
 * Decompiled with CFR 0.152.
 */
package moe.wolfgirl.powerfuljs.mixin.create;

import com.simibubi.create.content.kinetics.base.DirectionalKineticBlock;
import com.simibubi.create.content.kinetics.belt.BeltBlockEntity;
import com.simibubi.create.content.kinetics.deployer.DeployerBlockEntity;
import com.simibubi.create.content.logistics.depot.DepotBlockEntity;
import java.util.List;
import moe.wolfgirl.powerfuljs.custom.logic.behavior.EqualityCache;
import moe.wolfgirl.powerfuljs.custom.logic.behavior.ProgressProvider;
import moe.wolfgirl.powerfuljs.custom.logic.behavior.RecipeProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={DeployerBlockEntity.class})
public abstract class DeployerMixin
implements RecipeProvider,
ProgressProvider {
    @Shadow
    protected int timer;
    @Unique
    private EqualityCache.KeyAccessible<List<ItemStack>, ResourceLocation> pjs$cache = null;
    @Unique
    private boolean pjs$useMode = true;

    @Shadow
    @Nullable
    public abstract RecipeHolder<? extends Recipe<? extends RecipeInput>> getRecipe(ItemStack var1);

    @Override
    public int pjs$getProgress() {
        return 1000 - this.timer;
    }

    @Override
    public int pjs$getMaxProgress() {
        return 1000;
    }

    @Override
    public void pjs$setProgress(int progress) {
        this.timer = Math.max(1, 1000 - progress);
        this.pjs$self().sendData();
    }

    @Override
    public boolean pjs$running() {
        return this.timer > 0;
    }

    @Unique
    private DeployerBlockEntity pjs$self() {
        return (DeployerBlockEntity)this;
    }

    @Unique
    private List<ItemStack> pjs$getItem() {
        BlockPos pos;
        Level level = this.pjs$self().getLevel();
        BlockEntity be = level.getBlockEntity((pos = this.pjs$self().getBlockPos()).below(2));
        if (be instanceof BeltBlockEntity) {
            BeltBlockEntity beltBlockEntity = (BeltBlockEntity)be;
            return beltBlockEntity.getInventory().getTransportedItems().stream().map(t -> t.stack).toList();
        }
        if (be instanceof DepotBlockEntity) {
            DepotBlockEntity depotBlockEntity = (DepotBlockEntity)be;
            return List.of(depotBlockEntity.getHeldItem());
        }
        return List.of();
    }

    @Override
    @Nullable
    public ResourceLocation pjs$getRunningRecipe() {
        DeployerBlockEntity self = this.pjs$self();
        if (!this.pjs$running() || !this.pjs$useMode) {
            return null;
        }
        if (self.getBlockState().getValue((Property)DirectionalKineticBlock.FACING) != Direction.DOWN) {
            return null;
        }
        if (this.pjs$cache == null) {
            this.pjs$cache = new EqualityCache.KeyAccessible<List, ResourceLocation>(this::pjs$getItem, itemStacks -> {
                for (ItemStack itemStack : itemStacks) {
                    RecipeHolder<? extends Recipe<? extends RecipeInput>> r = this.getRecipe(itemStack.copyWithCount(1));
                    if (r == null) continue;
                    return r.id();
                }
                return null;
            });
        }
        return this.pjs$cache.get();
    }

    @Inject(method={"changeMode"}, at={@At(value="TAIL")}, remap=false)
    private void onModeChange(CallbackInfo ci) {
        this.pjs$useMode = !this.pjs$useMode;
    }

    @Inject(method={"read"}, at={@At(value="HEAD")})
    private void onReadFromNbt(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket, CallbackInfo ci) {
        if (clientPacket) {
            return;
        }
        String s = compound.getString("Mode");
        this.pjs$useMode = !s.equals("PUNCH");
    }
}

