/*
 * Decompiled with CFR 0.152.
 */
package moe.wolfgirl.powerfuljs.mixin;

import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.util.RemapForJS;
import dev.latvian.mods.rhino.util.RemapPrefixForJS;
import java.util.UUID;
import moe.wolfgirl.powerfuljs.GameStates;
import moe.wolfgirl.powerfuljs.custom.Attachments;
import moe.wolfgirl.powerfuljs.serde.SpeedModifiers;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.attachment.AttachmentType;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@RemapPrefixForJS(value="pjs$")
@Mixin(value={BlockEntity.class})
public abstract class BlockEntityMixin {
    @RemapForJS(value="setDataRaw")
    @Shadow
    public abstract <T> T setData(AttachmentType<T> var1, T var2);

    @Unique
    public <T> T pjs$setData(Context context, AttachmentType<T> type, Object data) {
        if (GameStates.ATTACHMENT_TYPE_INFO.containsKey(type)) {
            data = context.jsToJava(data, GameStates.ATTACHMENT_TYPE_INFO.get(type));
        }
        return (T)this.setData(type, data);
    }

    @Unique
    private BlockEntity pjs$self() {
        return (BlockEntity)this;
    }

    @Unique
    public void pjs$setTickingEnabled(boolean enabled) {
        if (enabled) {
            this.pjs$self().removeData(Attachments.DISABLED);
        } else {
            this.pjs$self().setData(Attachments.DISABLED, (Object)Unit.INSTANCE);
        }
    }

    @Unique
    public boolean pjs$isTickingEnabled() {
        return !this.pjs$self().hasData(Attachments.DISABLED);
    }

    @Unique
    public void pjs$addTickModifier(SpeedModifiers.SpeedModifier multiplier) {
        SpeedModifiers speedModifiers = (SpeedModifiers)this.pjs$self().getData(Attachments.TICK_SPEED);
        if (!speedModifiers.hasModifier(multiplier.id())) {
            this.pjs$self().setData(Attachments.TICK_SPEED, (Object)speedModifiers.withModifier(multiplier));
        }
    }

    @Unique
    public void pjs$removeTickModifier(String id) {
        SpeedModifiers speedModifiers = (SpeedModifiers)this.pjs$self().getData(Attachments.TICK_SPEED);
        if (speedModifiers.hasModifier(id)) {
            this.pjs$self().setData(Attachments.TICK_SPEED, (Object)speedModifiers.removeModifier(id));
        }
    }

    @Unique
    public SpeedModifiers pjs$getTickModifiers() {
        return (SpeedModifiers)this.pjs$self().getData(Attachments.TICK_SPEED);
    }

    @Unique
    public float pjs$getTickingSpeed() {
        return ((SpeedModifiers)this.pjs$self().getData(Attachments.TICK_SPEED)).getTickSpeed();
    }

    @Unique
    @Nullable
    public UUID pjs$getOwnerUUID() {
        return this.pjs$self().getExistingData(Attachments.OWNER).orElse(null);
    }

    @Unique
    public void pjs$setOwnerUUID(UUID uuid) {
        this.pjs$self().setData(Attachments.OWNER, (Object)uuid);
    }

    @Unique
    @Nullable
    public Player pjs$getOwner() {
        UUID ownerUuid = this.pjs$getOwnerUUID();
        if (ownerUuid == null) {
            return null;
        }
        Level level = this.pjs$self().getLevel();
        if (level == null) {
            return null;
        }
        return level.getPlayerByUUID(ownerUuid);
    }

    @Unique
    public void pjs$setOwner(Player player) {
        this.pjs$setOwnerUUID(player.getUUID());
    }
}

