/*
 * Decompiled with CFR 0.152.
 */
package moe.wolfgirl.powerfuljs.events;

import com.mojang.datafixers.util.Pair;
import dev.latvian.mods.kubejs.event.KubeEvent;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.util.ArrayList;
import java.util.List;
import moe.wolfgirl.powerfuljs.GameStates;
import moe.wolfgirl.powerfuljs.custom.base.CapabilityBuilder;
import moe.wolfgirl.powerfuljs.custom.base.info.BlockContext;
import moe.wolfgirl.powerfuljs.custom.registries.BlockCapabilityRegistry;
import moe.wolfgirl.powerfuljs.custom.registries.EntityCapabilityRegistry;
import moe.wolfgirl.powerfuljs.custom.registries.ItemCapabilityRegistry;
import moe.wolfgirl.powerfuljs.custom.registries.info.BlockEntityInfo;
import moe.wolfgirl.powerfuljs.custom.registries.info.BlockInfo;
import moe.wolfgirl.powerfuljs.custom.registries.info.CapabilityInfo;
import moe.wolfgirl.powerfuljs.custom.registries.info.EntityInfo;
import moe.wolfgirl.powerfuljs.custom.registries.info.ItemStackInfo;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.EntityCapability;
import net.neoforged.neoforge.capabilities.ItemCapability;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;

public class PowerfulRegisterCapabilitiesEvent
implements KubeEvent {
    private final List<Pair<Block, BlockInfo>> registeredBlocks = new ArrayList<Pair<Block, BlockInfo>>();
    private final List<Pair<Item, ItemStackInfo>> registeredItems = new ArrayList<Pair<Item, ItemStackInfo>>();
    private final List<Pair<EntityType<?>, EntityInfo>> registeredEntities = new ArrayList();

    public BlockInfo registerBlock(Context ctx, ResourceLocation builderKey, Object configuration, Block ... blocks) {
        CapabilityBuilder<BlockContext, ?> builder = BlockCapabilityRegistry.BLOCKS.get(builderKey);
        if (builder == null) {
            throw new IllegalArgumentException("Unknown capability builder %s!".formatted(builderKey));
        }
        BlockInfo info = new BlockInfo(builder.capability(), builder.wraps(ctx, configuration));
        for (Block block : blocks) {
            this.registeredBlocks.add((Pair<Block, BlockInfo>)new Pair((Object)block, (Object)info));
        }
        return info;
    }

    public BlockEntityInfo registerBlockEntity(Context ctx, ResourceLocation builderKey, Object configuration, BlockEntityType<?> blockEntityType) {
        CapabilityBuilder<BlockEntity, ?> builder = BlockCapabilityRegistry.BLOCK_ENTITIES.get(builderKey);
        if (builder == null) {
            throw new IllegalArgumentException("Unknown capability builder %s!".formatted(builderKey));
        }
        BlockEntityInfo info = new BlockEntityInfo(builder.capability(), builder.wraps(ctx, configuration));
        info.validate((i, c) -> {
            assert (i.blockEntity() != null);
            return i.blockEntity().getType() == blockEntityType;
        });
        for (Block validBlock : blockEntityType.getValidBlocks()) {
            this.registeredBlocks.add((Pair<Block, BlockInfo>)new Pair((Object)validBlock, (Object)info));
        }
        return info;
    }

    public ItemStackInfo registerItem(Context ctx, ResourceLocation builderKey, Object configuration, Item ... items) {
        CapabilityBuilder<ItemStack, ?> builder = ItemCapabilityRegistry.ITEM.get(builderKey);
        if (builder == null) {
            throw new IllegalArgumentException("Unknown capability builder %s!".formatted(builderKey));
        }
        ItemStackInfo info = new ItemStackInfo(builder.capability(), builder.wraps(ctx, configuration));
        for (Item item : items) {
            this.registeredItems.add((Pair<Item, ItemStackInfo>)new Pair((Object)item, (Object)info));
        }
        return info;
    }

    public EntityInfo registerEntity(Context ctx, ResourceLocation builderKey, Object configuration, EntityType<?> ... entityTypes) {
        CapabilityBuilder<Entity, ?> builder = EntityCapabilityRegistry.ENTITY.get(builderKey);
        if (builder == null) {
            throw new IllegalArgumentException("Unknown capability builder %s!".formatted(builderKey));
        }
        EntityInfo info = new EntityInfo(builder.capability(), builder.wraps(ctx, configuration));
        for (EntityType<?> entityType : entityTypes) {
            this.registeredEntities.add(new Pair(entityType, (Object)info));
        }
        return info;
    }

    @HideFromJS
    public <T, C> void register(RegisterCapabilitiesEvent event) {
        CapabilityInfo info;
        for (Pair<Block, BlockInfo> pair : this.registeredBlocks) {
            Block block = (Block)pair.getFirst();
            info = (BlockInfo)pair.getSecond();
            event.registerBlock((BlockCapability)((BlockInfo)info).capability, ((BlockInfo)info).build(), new Block[]{block});
            GameStates.REGISTERED_BLOCKS.add(block);
        }
        for (Pair pair : this.registeredItems) {
            Item item = (Item)pair.getFirst();
            info = (ItemStackInfo)pair.getSecond();
            event.registerItem((ItemCapability)((ItemStackInfo)info).capability, ((ItemStackInfo)info).build(), new ItemLike[]{item});
        }
        for (Pair pair : this.registeredEntities) {
            EntityType entity = (EntityType)pair.getFirst();
            info = (EntityInfo)pair.getSecond();
            event.registerEntity((EntityCapability)((EntityInfo)info).capability, entity, ((EntityInfo)info).build());
        }
    }
}

