/*
 * Decompiled with CFR 0.152.
 */
package moe.wolfgirl.powerfuljs.custom.mods.mekanism.heat.storage;

import java.util.EnumMap;
import mekanism.api.heat.IHeatHandler;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.heat.CachedAmbientTemperature;
import mekanism.common.util.EnumUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import org.jetbrains.annotations.Nullable;

public abstract class HeatHandler
implements IHeatHandler {
    private final EnumMap<Direction, BlockCapabilityCache<IHeatHandler, @Nullable Direction>> heatHandlers = new EnumMap(Direction.class);
    private CachedAmbientTemperature ambientTemperature = null;

    public final int getHeatCapacitorCount() {
        return 1;
    }

    public final double getInverseConduction(int capacitor) {
        return this.getConduction();
    }

    public final double getHeatCapacity(int capacitor) {
        return this.getCapacity();
    }

    public final double getTemperature(int capacitor) {
        double heat = this.getHeatData();
        if (heat == -1.0) {
            return this.getInitialTemperature();
        }
        return this.getHeatData() / this.getCapacity();
    }

    public void handleHeat(int capacitor, double transfer) {
        if (Math.abs(transfer) <= (double)1.0E-6f) {
            return;
        }
        double currentHeat = this.getHeatData();
        if (currentHeat == -1.0) {
            currentHeat = this.getCapacity() * this.getInitialTemperature();
        }
        this.setHeatData(currentHeat += transfer);
        this.onChanged(transfer);
    }

    public double simulateEnvironment(ServerLevel level, BlockPos thisPos) {
        double environmentTransfer = 0.0;
        double capacity = this.getCapacity();
        double temperature = this.getTemperature(0);
        if (this.heatHandlers.isEmpty()) {
            for (Direction direction : EnumUtils.DIRECTIONS) {
                this.heatHandlers.put(direction, (BlockCapabilityCache<IHeatHandler, Direction>)BlockCapabilityCache.create((BlockCapability)Capabilities.HEAT, (ServerLevel)level, (BlockPos)thisPos.relative(direction), (Object)direction.getOpposite()));
            }
        }
        if (this.ambientTemperature == null) {
            this.ambientTemperature = new CachedAmbientTemperature(() -> level, () -> thisPos);
        }
        for (Direction direction : EnumUtils.DIRECTIONS) {
            double heatTransferred;
            IHeatHandler sink = (IHeatHandler)this.heatHandlers.get(direction).getCapability();
            if (sink != null) {
                double conduction = this.getConduction() + sink.getTotalInverseConduction();
                tempDiff = (temperature - sink.getTotalTemperature()) / conduction;
                if (tempDiff < (double)1.0E-6f) continue;
                heatTransferred = tempDiff * capacity;
                sink.handleHeat(heatTransferred);
            } else {
                double airConduction = 10000.0 + this.getInsulation() + this.getConduction();
                tempDiff = (temperature - this.getAmbientTemperature(direction)) / airConduction;
                heatTransferred = Math.max(0.0, tempDiff * capacity);
            }
            this.handleHeat(-heatTransferred);
            environmentTransfer += heatTransferred;
        }
        return environmentTransfer;
    }

    private double getAmbientTemperature(Direction direction) {
        if (this.ambientTemperature == null) {
            return 300.0;
        }
        return this.ambientTemperature.getTemperature(direction);
    }

    protected abstract void setHeatData(double var1);

    protected abstract double getHeatData();

    protected abstract double getInitialTemperature();

    protected abstract double getInsulation();

    protected abstract double getConduction();

    protected abstract double getCapacity();

    protected abstract void onChanged(double var1);
}

