/*
 * Decompiled with CFR 0.152.
 */
package moe.wolfgirl.powerfuljs.custom.mods.mekanism.heat.storage;

import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.type.RecordTypeInfo;
import dev.latvian.mods.rhino.type.TypeInfo;
import mekanism.api.heat.IHeatHandler;
import mekanism.common.capabilities.Capabilities;
import moe.wolfgirl.powerfuljs.custom.base.CapabilityBuilder;
import moe.wolfgirl.powerfuljs.custom.mods.mekanism.MekAttachments;
import moe.wolfgirl.powerfuljs.custom.mods.mekanism.heat.storage.HeatHandler;
import moe.wolfgirl.powerfuljs.utils.MCID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;

public class FixedHeatStorage
extends HeatHandler {
    public static final ResourceLocation ID = MCID.create("fixed_storage_heat");
    public static final CapabilityBuilder<BlockEntity, IHeatHandler> BLOCK_ENTITY = CapabilityBuilder.create(ID, Capabilities.HEAT, (TypeInfo)Configuration.TYPE_INFO, FixedHeatStorage::wraps);
    private final double insulation;
    private final double conduction;
    private final double capacity;
    private final double initialTemperature;
    private final BlockEntity parent;

    public static CapabilityBuilder.CapabilityFactory<BlockEntity, IHeatHandler> wraps(Context ctx, Object configuration) {
        Configuration c = (Configuration)Configuration.TYPE_INFO.wrap(ctx, configuration, (TypeInfo)Configuration.TYPE_INFO);
        return object -> new FixedHeatStorage(c.insulation, c.conduction, c.capacity, c.initialTemperature, (BlockEntity)object);
    }

    public FixedHeatStorage(double insulation, double conduction, double capacity, double initialTemperature, BlockEntity parent) {
        this.insulation = insulation;
        this.conduction = conduction;
        this.capacity = capacity;
        this.initialTemperature = initialTemperature == 0.0 ? 300.0 : initialTemperature;
        this.parent = parent;
    }

    @Override
    protected void setHeatData(double heatData) {
        this.parent.setData(MekAttachments.HEAT, (Object)heatData);
    }

    @Override
    protected double getHeatData() {
        return (Double)this.parent.getData(MekAttachments.HEAT);
    }

    @Override
    protected double getInitialTemperature() {
        return this.initialTemperature;
    }

    @Override
    protected double getInsulation() {
        return this.insulation;
    }

    @Override
    protected double getConduction() {
        return this.conduction;
    }

    @Override
    protected double getCapacity() {
        return this.capacity;
    }

    @Override
    protected void onChanged(double transferred) {
        this.parent.setChanged();
    }

    public record Configuration(double insulation, double conduction, double capacity, double initialTemperature) {
        public static final RecordTypeInfo TYPE_INFO = (RecordTypeInfo)TypeInfo.of(Configuration.class);
    }
}

