/*
 * Decompiled with CFR 0.152.
 */
package moe.wolfgirl.powerfuljs.custom.mods.mekanism.chemical.storage;

import mekanism.api.Action;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import moe.wolfgirl.powerfuljs.utils.MathUtils;
import org.jetbrains.annotations.NotNull;

public abstract class ChemicalHandler
implements IChemicalHandler {
    public int getChemicalTanks() {
        return 1;
    }

    @NotNull
    public ChemicalStack getChemicalInTank(int tank) {
        return this.getChemicalData();
    }

    public void setChemicalInTank(int tank, @NotNull ChemicalStack stack) {
        this.setChemicalData(stack);
    }

    @NotNull
    public ChemicalStack insertChemical(int tank, @NotNull ChemicalStack stack, @NotNull Action action) {
        return this.insertChemical(tank, stack, action, false);
    }

    @NotNull
    public ChemicalStack insertChemical(int tank, @NotNull ChemicalStack stack, @NotNull Action action, boolean forced) {
        if (tank != 0 || stack.isEmpty() || !this.isValid(0, stack)) {
            return stack;
        }
        ChemicalStack currentStack = this.getChemicalData();
        if (!currentStack.isEmpty() && !ChemicalStack.isSameChemical((ChemicalStack)currentStack, (ChemicalStack)stack)) {
            return stack;
        }
        long inserted = MathUtils.min(this.getChemicalTankCapacity(0) - currentStack.getAmount(), stack.getAmount(), forced ? Long.MAX_VALUE : this.getMaxReceive());
        if (inserted <= 0L) {
            return stack;
        }
        if (action.execute()) {
            this.setChemicalData(stack.copyWithAmount(currentStack.getAmount() + inserted));
            this.onReceived(stack.copyWithAmount(inserted));
            this.onChanged();
        }
        if (stack.getAmount() == inserted) {
            return ChemicalStack.EMPTY;
        }
        return stack.copyWithAmount(stack.getAmount() - inserted);
    }

    @NotNull
    public ChemicalStack extractChemical(int tank, long amount, @NotNull Action action) {
        return this.extractChemical(tank, amount, action, false);
    }

    @NotNull
    public ChemicalStack extractChemical(int tank, long amount, @NotNull Action action, boolean forced) {
        if (tank != 0 || amount <= 0L) {
            return ChemicalStack.EMPTY;
        }
        ChemicalStack currentStack = this.getChemicalData();
        long extracted = MathUtils.min(currentStack.getAmount(), amount, forced ? Long.MAX_VALUE : this.getMaxExtract());
        if (extracted <= 0L) {
            return ChemicalStack.EMPTY;
        }
        ChemicalStack extractedStack = currentStack.copyWithAmount(extracted);
        if (action.execute()) {
            this.setChemicalData(extractedStack.getAmount() == currentStack.getAmount() ? ChemicalStack.EMPTY : currentStack.copyWithAmount(currentStack.getAmount() - extractedStack.getAmount()));
        }
        return extractedStack;
    }

    protected abstract long getMaxReceive();

    protected abstract long getMaxExtract();

    protected abstract void setChemicalData(ChemicalStack var1);

    protected abstract ChemicalStack getChemicalData();

    protected void onChanged() {
    }

    protected void onReceived(ChemicalStack stack) {
    }

    protected void onExtracted(int amount) {
    }
}

