/*
 * Decompiled with CFR 0.152.
 */
package moe.wolfgirl.powerfuljs.custom.mods.mekanism.chemical;

import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.type.RecordTypeInfo;
import dev.latvian.mods.rhino.type.TypeInfo;
import mekanism.api.Action;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.common.capabilities.Capabilities;
import moe.wolfgirl.powerfuljs.custom.base.CapabilityBuilder;
import moe.wolfgirl.powerfuljs.custom.base.info.BlockContext;
import moe.wolfgirl.powerfuljs.utils.MCID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class ConstantChemical
implements IChemicalHandler {
    public static final ResourceLocation ID = MCID.create("constant_chemical");
    public static final CapabilityBuilder<ItemStack, IChemicalHandler> ITEM = CapabilityBuilder.create(ID, Capabilities.CHEMICAL.item(), (TypeInfo)Configuration.TYPE_INFO, ConstantChemical::wraps);
    public static final CapabilityBuilder<BlockEntity, IChemicalHandler> BLOCK_ENTITY = CapabilityBuilder.create(ID, Capabilities.CHEMICAL.block(), (TypeInfo)Configuration.TYPE_INFO, ConstantChemical::wraps);
    public static final CapabilityBuilder<BlockContext, IChemicalHandler> BLOCK = CapabilityBuilder.create(ID, Capabilities.CHEMICAL.block(), (TypeInfo)Configuration.TYPE_INFO, ConstantChemical::wraps);
    public static final CapabilityBuilder<Entity, IChemicalHandler> ENTITY = CapabilityBuilder.create(ID, Capabilities.CHEMICAL.entity(), (TypeInfo)Configuration.TYPE_INFO, ConstantChemical::wraps);
    private final ChemicalStack chemical;

    public static <O> CapabilityBuilder.CapabilityFactory<O, IChemicalHandler> wraps(Context ctx, Object configuration) {
        Configuration c = (Configuration)Configuration.TYPE_INFO.wrap(ctx, configuration, (TypeInfo)Configuration.TYPE_INFO);
        return object -> new ConstantChemical(c.stack);
    }

    public ConstantChemical(ChemicalStack chemical) {
        this.chemical = chemical;
    }

    public int getChemicalTanks() {
        return 1;
    }

    @NotNull
    public ChemicalStack getChemicalInTank(int tank) {
        return this.chemical.copy();
    }

    public void setChemicalInTank(int tank, @NotNull ChemicalStack stack) {
    }

    public long getChemicalTankCapacity(int tank) {
        return this.chemical.getAmount();
    }

    public boolean isValid(int tank, @NotNull ChemicalStack stack) {
        return ChemicalStack.isSameChemical((ChemicalStack)stack, (ChemicalStack)this.chemical);
    }

    @NotNull
    public ChemicalStack insertChemical(int tank, @NotNull ChemicalStack stack, @NotNull Action action) {
        return stack;
    }

    @NotNull
    public ChemicalStack extractChemical(int tank, long amount, @NotNull Action action) {
        return this.chemical.copyWithAmount(Math.min(this.chemical.getAmount(), amount));
    }

    public record Configuration(ChemicalStack stack) {
        public static final RecordTypeInfo TYPE_INFO = (RecordTypeInfo)TypeInfo.of(Configuration.class);
    }
}

