/*
 * Decompiled with CFR 0.152.
 */
package moe.wolfgirl.powerfuljs.custom.logic.rules.machine;

import java.util.Optional;
import java.util.Set;
import moe.wolfgirl.powerfuljs.GameStates;
import moe.wolfgirl.powerfuljs.custom.logic.Rule;
import moe.wolfgirl.powerfuljs.custom.logic.behavior.MultiRecipeProvider;
import moe.wolfgirl.powerfuljs.custom.logic.behavior.RecipeProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class MachineRunningRecipeTag
extends Rule {
    private final Set<ResourceLocation> tags;

    public MachineRunningRecipeTag(Set<ResourceLocation> tags) {
        this.tags = tags;
    }

    @Override
    public boolean evaluate(Level level, BlockPos pos, BlockState state, BlockEntity blockEntity) {
        if (blockEntity instanceof RecipeProvider) {
            RecipeProvider provider = (RecipeProvider)blockEntity;
            Set recipeTags = GameStates.RECIPE_TAGS.getOrDefault(provider.pjs$getRunningRecipe(), Set.of());
            for (ResourceLocation tag : this.tags) {
                if (recipeTags.contains(tag)) continue;
                return false;
            }
            return true;
        }
        if (blockEntity instanceof MultiRecipeProvider) {
            MultiRecipeProvider multiProvider = (MultiRecipeProvider)blockEntity;
            for (Optional<ResourceLocation> resourceLocation : multiProvider.pjs$getRunningRecipe()) {
                if (!resourceLocation.map(recipeId -> {
                    Set recipeTags = GameStates.RECIPE_TAGS.getOrDefault(recipeId, Set.of());
                    for (ResourceLocation tag : this.tags) {
                        if (recipeTags.contains(tag)) continue;
                        return false;
                    }
                    return true;
                }).orElse(false).booleanValue()) continue;
                return true;
            }
            return false;
        }
        return false;
    }
}

