/*
 * Decompiled with CFR 0.152.
 */
package moe.wolfgirl.powerfuljs.custom.logic.rules.machine;

import java.util.Optional;
import java.util.Set;
import moe.wolfgirl.powerfuljs.custom.logic.Rule;
import moe.wolfgirl.powerfuljs.custom.logic.behavior.MultiRecipeProvider;
import moe.wolfgirl.powerfuljs.custom.logic.behavior.RecipeProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class MachineRunningRecipe
extends Rule {
    private final Set<ResourceLocation> recipesToCheck;

    public MachineRunningRecipe(Set<ResourceLocation> recipesToCheck) {
        this.recipesToCheck = recipesToCheck;
    }

    @Override
    public boolean evaluate(Level level, BlockPos pos, BlockState state, BlockEntity blockEntity) {
        if (blockEntity instanceof RecipeProvider) {
            RecipeProvider provider = (RecipeProvider)blockEntity;
            ResourceLocation running = provider.pjs$getRunningRecipe();
            return running != null && this.recipesToCheck.contains(running);
        }
        if (blockEntity instanceof MultiRecipeProvider) {
            MultiRecipeProvider multiProvider = (MultiRecipeProvider)blockEntity;
            for (Optional<ResourceLocation> resourceLocation : multiProvider.pjs$getRunningRecipe()) {
                if (!resourceLocation.map(this.recipesToCheck::contains).orElse(false).booleanValue()) continue;
                return true;
            }
        }
        return false;
    }
}

