/*
 * Decompiled with CFR 0.152.
 */
package moe.wolfgirl.powerfuljs.custom.logic.rules;

import moe.wolfgirl.powerfuljs.custom.logic.Rule;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import org.jetbrains.annotations.Nullable;

public abstract class CapabilityRule<T, C>
extends Rule {
    private final BlockCapability<T, C> blockCapability;
    @Nullable
    private final C context;
    private BlockCapabilityCache<T, C> cache;

    protected CapabilityRule(BlockCapability<T, C> blockCapability, @Nullable C context) {
        this.blockCapability = blockCapability;
        this.context = context;
    }

    protected abstract boolean evaluateCap(T var1);

    @Override
    public final boolean evaluate(Level level, BlockPos pos, BlockState state, BlockEntity blockEntity) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.cache == null) {
                this.cache = BlockCapabilityCache.create(this.blockCapability, (ServerLevel)serverLevel, (BlockPos)pos, this.context);
            }
            return this.evaluateCap(this.cache.getCapability());
        }
        Object cap = level.getCapability(this.blockCapability, pos, this.context);
        return this.evaluateCap(cap);
    }
}

