/*
 * Decompiled with CFR 0.152.
 */
package moe.wolfgirl.powerfuljs.custom.logic.rules;

import java.util.function.Predicate;
import moe.wolfgirl.powerfuljs.custom.logic.Rule;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.attachment.AttachmentType;

public abstract class AttachmentRule<T>
extends Rule {
    private final AttachmentType<T> attachmentType;

    protected AttachmentRule(AttachmentType<T> attachmentType) {
        this.attachmentType = attachmentType;
    }

    protected abstract boolean testAttachment(T var1);

    @Override
    public boolean evaluate(Level level, BlockPos pos, BlockState state, BlockEntity blockEntity) {
        Object data = blockEntity.getData(this.attachmentType);
        return this.testAttachment(data);
    }

    public static class Present
    extends Rule {
        private final AttachmentType<?> attachmentType;

        public Present(AttachmentType<?> attachmentType) {
            this.attachmentType = attachmentType;
        }

        @Override
        public boolean evaluate(Level level, BlockPos pos, BlockState state, BlockEntity blockEntity) {
            return blockEntity.hasData(this.attachmentType);
        }
    }

    public static class Custom<T>
    extends AttachmentRule<T> {
        private final Predicate<T> test;
        private T cachedData;
        private boolean cachedResult;

        public Custom(AttachmentType<T> attachmentType, Predicate<T> test) {
            super(attachmentType);
            this.test = test;
        }

        @Override
        protected boolean testAttachment(T data) {
            if (this.cachedData == null || !this.cachedData.equals(data)) {
                this.cachedData = data;
                this.cachedResult = this.test.test(this.cachedData);
            }
            return this.cachedResult;
        }
    }

    public static class NativeComparable<T extends Comparable<T>>
    extends AttachmentRule<T> {
        private final T criteria;
        private final CompareAction action;

        public NativeComparable(AttachmentType<T> attachmentType, T criteria, CompareAction action) {
            super(attachmentType);
            this.criteria = criteria;
            this.action = action;
        }

        @Override
        protected boolean testAttachment(T data) {
            return this.action.test(data, this.criteria);
        }
    }

    public static enum CompareAction {
        EQUALS,
        NOT_EQUALS,
        GREATER_THAN,
        LESS_THAN,
        NOT_GREATER_THAN,
        NOT_LESS_THAN;


        public <T extends Comparable<T>> boolean test(T obj1, T obj2) {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> obj1.equals(obj2);
                case 1 -> {
                    if (!obj1.equals(obj2)) {
                        yield true;
                    }
                    yield false;
                }
                case 2 -> {
                    if (obj1.compareTo(obj2) > 0) {
                        yield true;
                    }
                    yield false;
                }
                case 3 -> {
                    if (obj1.compareTo(obj2) < 0) {
                        yield true;
                    }
                    yield false;
                }
                case 4 -> {
                    if (obj1.compareTo(obj2) <= 0) {
                        yield true;
                    }
                    yield false;
                }
                case 5 -> obj1.compareTo(obj2) >= 0;
            };
        }
    }
}

