/*
 * Decompiled with CFR 0.152.
 */
package moe.wolfgirl.powerfuljs.custom.logic.behavior;

import dev.latvian.mods.rhino.util.HideFromJS;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

@HideFromJS
public class ReflectiveAccessor {
    private final Field field;
    private final Method getter;
    private final Method setter;

    public ReflectiveAccessor(Field field, Method getter, Method setter) {
        this.field = field;
        this.getter = getter;
        this.setter = setter;
    }

    public Object get(Object object) throws InvocationTargetException, IllegalAccessException {
        if (this.field != null) {
            return this.field.get(object);
        }
        if (this.getter != null) {
            return this.getter.invoke(object, new Object[0]);
        }
        return null;
    }

    public void set(Object object, Object value) throws IllegalAccessException, InvocationTargetException {
        if (this.field != null) {
            this.field.set(object, value);
        } else if (this.setter != null) {
            this.setter.invoke(object, value);
        }
    }

    public boolean isReadable() {
        return this.field != null || this.getter != null;
    }

    public boolean isWritable() {
        return this.field != null || this.setter != null;
    }

    public static ReflectiveAccessor of(Class<?> clazz, String accessor) throws NoSuchFieldException, NoSuchMethodException {
        if (accessor.contains("/")) {
            Method setter;
            String[] getSet = accessor.split("/");
            Method getter = getSet[0].equals("-") ? null : clazz.getDeclaredMethod(getSet[0], new Class[0]);
            Method method = setter = getSet[1].equals("-") ? null : clazz.getDeclaredMethod(getSet[1], new Class[0]);
            if (getter != null) {
                getter.setAccessible(true);
            }
            if (setter != null) {
                setter.setAccessible(true);
            }
            return new ReflectiveAccessor(null, getter, setter);
        }
        Field field = clazz.getDeclaredField(accessor);
        field.setAccessible(true);
        return new ReflectiveAccessor(field, null, null);
    }
}

