/*
 * Decompiled with CFR 0.152.
 */
package moe.wolfgirl.powerfuljs.custom.logic.behavior;

import java.util.function.Function;
import java.util.function.Supplier;

public class IdentityCache<C, T> {
    private C condition;
    private T value;
    private final Supplier<C> conditionGetter;
    private final Supplier<T> valueGetter;

    public IdentityCache(Supplier<C> conditionGetter, Supplier<T> valueGetter) {
        this.conditionGetter = conditionGetter;
        this.valueGetter = valueGetter;
    }

    public T get() {
        C current = this.conditionGetter.get();
        if (this.condition != current) {
            this.condition = current;
            this.value = this.valueGetter.get();
        }
        return this.value;
    }

    public static class KeyAccessible<C, T> {
        private C condition;
        private T value;
        private final Supplier<C> conditionGetter;
        private final Function<C, T> valueGetter;

        public KeyAccessible(Supplier<C> conditionGetter, Function<C, T> valueGetter) {
            this.conditionGetter = conditionGetter;
            this.valueGetter = valueGetter;
        }

        public T get() {
            C current = this.conditionGetter.get();
            if (this.condition != current) {
                this.condition = current;
                this.value = this.valueGetter.apply(this.condition);
            }
            return this.value;
        }
    }
}

