/*
 * Decompiled with CFR 0.152.
 */
package moe.wolfgirl.powerfuljs.custom.logic;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import moe.wolfgirl.powerfuljs.custom.Attachments;
import moe.wolfgirl.powerfuljs.custom.logic.Effect;
import moe.wolfgirl.powerfuljs.custom.logic.rules.logic.AlwaysRule;
import moe.wolfgirl.powerfuljs.custom.logic.rules.logic.AndRule;
import moe.wolfgirl.powerfuljs.custom.logic.rules.logic.NotRule;
import moe.wolfgirl.powerfuljs.custom.logic.rules.logic.OrRule;
import moe.wolfgirl.powerfuljs.serde.SpeedModifiers;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public abstract class Rule {
    private final List<Effect> effects = new ArrayList<Effect>();

    public Rule effect(Effect effect) {
        this.effects.add(effect);
        return this;
    }

    public Rule effects(Effect ... effects) {
        this.effects.addAll(List.of(effects));
        return this;
    }

    public Rule negate() {
        return new NotRule(this);
    }

    public Rule and(Rule ... rules) {
        ArrayList<Rule> flattened = new ArrayList<Rule>();
        flattened.add(this);
        for (Rule rule : rules) {
            if (rule instanceof AndRule) {
                AndRule andRule = (AndRule)rule;
                flattened.addAll(andRule.rules);
                continue;
            }
            flattened.add(rule);
        }
        return new AndRule((List<Rule>)ImmutableList.copyOf(flattened));
    }

    public Rule then(Rule rule) {
        return this.and(rule);
    }

    public Rule thenRun(Effect ... effects) {
        return this.then(new AlwaysRule(true).effects(effects));
    }

    public Rule or(Rule ... rules) {
        ArrayList<Rule> flattened = new ArrayList<Rule>();
        flattened.add(this);
        for (Rule rule : rules) {
            if (rule instanceof OrRule) {
                OrRule orRule = (OrRule)rule;
                flattened.addAll(orRule.rules);
                continue;
            }
            flattened.add(rule);
        }
        return new OrRule((List<Rule>)ImmutableList.copyOf(flattened));
    }

    public abstract boolean evaluate(Level var1, BlockPos var2, BlockState var3, BlockEntity var4);

    public final boolean run(Level level, BlockPos pos, BlockState state, BlockEntity blockEntity) {
        boolean condition = this.evaluate(level, pos, state, blockEntity);
        for (Effect effect : this.effects) {
            effect.apply(condition, level, pos, state, blockEntity);
        }
        return condition;
    }

    private static <T extends BlockEntity> void advanceTicks(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, T blockEntity, BlockEntityTicker<T> original, int ticks) {
        if (ticks == 0) {
            return;
        }
        for (int i = 0; i < ticks; ++i) {
            original.tick(level, pos, state, blockEntity);
        }
    }

    public static class PowerfulJSDefaultTicker<T extends BlockEntity>
    implements BlockEntityTicker<T> {
        private final BlockEntityTicker<T> original;
        private float ticks = 0.0f;
        private float cachedModifier = 1.0f;
        private final float baseTickSpeed;
        private SpeedModifiers modifiers = SpeedModifiers.EMPTY;

        public PowerfulJSDefaultTicker(BlockEntityTicker<T> original, float baseTickSpeed) {
            this.original = original;
            this.baseTickSpeed = baseTickSpeed;
        }

        public void tick(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, T blockEntity) {
            if (!blockEntity.hasData(Attachments.DISABLED)) {
                SpeedModifiers speedModifiers = (SpeedModifiers)blockEntity.getData(Attachments.TICK_SPEED);
                if (this.modifiers != speedModifiers) {
                    this.modifiers = speedModifiers;
                    this.cachedModifier = this.modifiers.getTickSpeed();
                }
                this.ticks += this.cachedModifier * this.baseTickSpeed;
                int advancedTicks = (int)Math.floor(this.ticks);
                Rule.advanceTicks(level, pos, state, blockEntity, this.original, advancedTicks);
                this.ticks -= (float)advancedTicks;
            }
        }
    }

    private static class PowerfulJSTicker<T extends BlockEntity>
    implements BlockEntityTicker<T> {
        private final List<Rule> rules;
        private float ticks = 0.0f;
        private float cachedModifier = 1.0f;
        private final float baseTickSpeed;
        private SpeedModifiers modifiers = SpeedModifiers.EMPTY;
        private final BlockEntityTicker<T> original;

        private PowerfulJSTicker(List<Rule> rules, float baseTickSpeed, BlockEntityTicker<T> original) {
            this.rules = rules;
            this.baseTickSpeed = baseTickSpeed;
            this.original = original;
        }

        public void tick(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull T blockEntity) {
            for (Rule rule : this.rules) {
                rule.run(level, pos, state, (BlockEntity)blockEntity);
            }
            if (!blockEntity.hasData(Attachments.DISABLED)) {
                SpeedModifiers speedModifiers = (SpeedModifiers)blockEntity.getData(Attachments.TICK_SPEED);
                if (this.modifiers != speedModifiers) {
                    this.modifiers = speedModifiers;
                    this.cachedModifier = this.modifiers.getTickSpeed();
                }
                this.ticks += this.cachedModifier * this.baseTickSpeed;
                int advancedTicks = (int)Math.floor(this.ticks);
                Rule.advanceTicks(level, pos, state, blockEntity, this.original, advancedTicks);
                this.ticks -= (float)advancedTicks;
            }
        }
    }

    public record RuleSet(Supplier<List<Rule>> rules) {
        public static <T extends BlockEntity> BlockEntityTicker<T> createTicker(Collection<RuleSet> ruleSets, BlockEntityTicker<T> original, float baseTickSpeed) {
            ArrayList allRules = new ArrayList();
            for (RuleSet ruleSet : ruleSets) {
                allRules.addAll(ruleSet.rules.get());
            }
            return new PowerfulJSTicker<T>(List.copyOf(allRules), baseTickSpeed, original);
        }
    }
}

