/*
 * Decompiled with CFR 0.152.
 */
package moe.wolfgirl.powerfuljs.custom.item.storage;

import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public abstract class BaseItemStorage
implements IItemHandler {
    protected abstract void setStackInSlot(int var1, ItemStack var2);

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        if (stack.isEmpty() || !this.isSlotValid(slot) || !this.isItemValid(slot, stack)) {
            return stack;
        }
        int limit = Math.min(this.getSlotLimit(slot), stack.getMaxStackSize());
        ItemStack current = this.getStackInSlot(slot);
        if (!current.isEmpty() && !ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)current)) {
            return stack;
        }
        int inserted = Math.min(limit - current.getCount(), stack.getCount());
        if (inserted <= 0) {
            return stack;
        }
        if (!simulate) {
            this.setStackInSlot(slot, stack.copyWithCount(inserted + current.getCount()));
            this.onReceived(slot, stack.copyWithCount(inserted));
            this.onChanged();
        }
        return inserted == stack.getCount() ? ItemStack.EMPTY : stack.copyWithCount(stack.getCount() - inserted);
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0 || !this.isSlotValid(slot)) {
            return ItemStack.EMPTY;
        }
        ItemStack current = this.getStackInSlot(slot);
        if (current.isEmpty()) {
            return ItemStack.EMPTY;
        }
        int toExtract = Math.min(amount, current.getCount());
        ItemStack extracted = current.copyWithCount(toExtract);
        if (!simulate) {
            this.setStackInSlot(slot, toExtract == current.getCount() ? ItemStack.EMPTY : current.copyWithCount(current.getCount() - toExtract));
            this.onExtracted(slot, extracted);
            this.onChanged();
        }
        return extracted;
    }

    protected boolean isSlotValid(int slot) {
        return slot >= 0 && slot < this.getSlots();
    }

    protected void onExtracted(int slot, ItemStack stack) {
    }

    protected void onReceived(int slot, ItemStack stack) {
    }

    protected void onChanged() {
    }
}

