/*
 * Decompiled with CFR 0.152.
 */
package moe.wolfgirl.powerfuljs.custom.forge_energy.storage;

import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.type.RecordTypeInfo;
import dev.latvian.mods.rhino.type.TypeInfo;
import moe.wolfgirl.powerfuljs.custom.Attachments;
import moe.wolfgirl.powerfuljs.custom.DataComponents;
import moe.wolfgirl.powerfuljs.custom.base.CapabilityBuilder;
import moe.wolfgirl.powerfuljs.custom.forge_energy.storage.BaseEnergyStorage;
import moe.wolfgirl.powerfuljs.utils.MCID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.attachment.AttachmentHolder;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.MutableDataComponentHolder;
import net.neoforged.neoforge.energy.IEnergyStorage;

public abstract class FixedEnergyStorage
extends BaseEnergyStorage {
    public static final ResourceLocation ID = MCID.create("fixed_storage_fe");
    public static final CapabilityBuilder<BlockEntity, IEnergyStorage> BLOCK_ENTITY = CapabilityBuilder.create(ID, Capabilities.EnergyStorage.BLOCK, (TypeInfo)Configuration.TYPE_INFO, FixedEnergyStorage::wrapsAttachment);
    public static final CapabilityBuilder<Entity, IEnergyStorage> ENTITY = CapabilityBuilder.create(ID, Capabilities.EnergyStorage.ENTITY, (TypeInfo)Configuration.TYPE_INFO, FixedEnergyStorage::wrapsAttachment);
    public static final CapabilityBuilder<ItemStack, IEnergyStorage> ITEM = CapabilityBuilder.create(ID, Capabilities.EnergyStorage.ITEM, (TypeInfo)Configuration.TYPE_INFO, FixedEnergyStorage::wrapsComponent);
    private final int capacity;
    private final int maxReceive;
    private final int maxExtract;

    public static <O extends AttachmentHolder> CapabilityBuilder.CapabilityFactory<O, IEnergyStorage> wrapsAttachment(Context ctx, Object configuration) {
        Configuration c = (Configuration)Configuration.TYPE_INFO.wrap(ctx, configuration, (TypeInfo)Configuration.TYPE_INFO);
        return object -> new Attachment(c.capacity, c.maxReceive, c.maxExtract, (AttachmentHolder)object);
    }

    public static <O extends MutableDataComponentHolder> CapabilityBuilder.CapabilityFactory<O, IEnergyStorage> wrapsComponent(Context ctx, Object configuration) {
        Configuration c = (Configuration)Configuration.TYPE_INFO.wrap(ctx, configuration, (TypeInfo)Configuration.TYPE_INFO);
        return object -> new Component(c.capacity, c.maxReceive, c.maxExtract, (MutableDataComponentHolder)object);
    }

    protected FixedEnergyStorage(int capacity, int maxReceive, int maxExtract) {
        this.capacity = capacity;
        this.maxReceive = maxReceive;
        this.maxExtract = maxExtract;
    }

    public int getMaxEnergyStored() {
        return this.capacity;
    }

    @Override
    public int getMaxExtract() {
        return this.maxExtract;
    }

    @Override
    public int getMaxReceive() {
        return this.maxReceive;
    }

    public record Configuration(int capacity, int maxExtract, int maxReceive) {
        public static final RecordTypeInfo TYPE_INFO = (RecordTypeInfo)TypeInfo.of(Configuration.class);
    }

    public static class Component
    extends FixedEnergyStorage {
        private final MutableDataComponentHolder parent;

        protected Component(int capacity, int maxReceive, int maxExtract, MutableDataComponentHolder parent) {
            super(capacity, maxReceive, maxExtract);
            this.parent = parent;
        }

        @Override
        protected void setEnergyData(int energy) {
            this.parent.set(DataComponents.FORGE_ENERGY, (Object)energy);
        }

        @Override
        protected int getEnergyData() {
            return (Integer)this.parent.getOrDefault(DataComponents.FORGE_ENERGY, (Object)0);
        }
    }

    public static class Attachment
    extends FixedEnergyStorage {
        private final AttachmentHolder parent;

        protected Attachment(int capacity, int maxReceive, int maxExtract, AttachmentHolder parent) {
            super(capacity, maxReceive, maxExtract);
            this.parent = parent;
        }

        @Override
        protected void setEnergyData(int energy) {
            this.parent.setData(Attachments.FORGE_ENERGY, (Object)energy);
        }

        @Override
        protected int getEnergyData() {
            return (Integer)this.parent.getData(Attachments.FORGE_ENERGY);
        }

        @Override
        protected void onChanged() {
            AttachmentHolder attachmentHolder = this.parent;
            if (attachmentHolder instanceof BlockEntity) {
                BlockEntity blockEntity = (BlockEntity)attachmentHolder;
                blockEntity.setChanged();
            }
        }
    }
}

