/*
 * Decompiled with CFR 0.152.
 */
package moe.wolfgirl.powerfuljs.custom.forge_energy.storage;

import net.minecraft.util.Mth;
import net.neoforged.neoforge.energy.IEnergyStorage;

public abstract class BaseEnergyStorage
implements IEnergyStorage {
    public int receiveEnergy(int toReceive, boolean simulate) {
        return this.receiveEnergy(toReceive, simulate, false);
    }

    public int receiveEnergy(int toReceive, boolean simulate, boolean forced) {
        if (!this.canReceive() && !forced || toReceive <= 0) {
            return 0;
        }
        int energy = this.getEnergyStored();
        int received = Mth.clamp((int)(this.getMaxEnergyStored() - energy), (int)0, (int)(forced ? toReceive : Math.min(this.getMaxReceive(), toReceive)));
        if (received > 0) {
            if (!simulate) {
                this.setEnergyData(energy + received);
                this.onChanged();
            }
            this.onReceived(received, simulate);
        }
        return received;
    }

    public int extractEnergy(int toExtract, boolean simulate) {
        return this.extractEnergy(toExtract, simulate, false);
    }

    public int extractEnergy(int toExtract, boolean simulate, boolean forced) {
        if (!this.canExtract() && !forced || toExtract <= 0) {
            return 0;
        }
        int energy = this.getEnergyStored();
        int extracted = Math.min(energy, forced ? toExtract : Math.min(this.getMaxExtract(), toExtract));
        if (extracted > 0) {
            if (!simulate) {
                this.setEnergyData(energy - extracted);
                this.onChanged();
            }
            this.onExtracted(energy, simulate);
        }
        return extracted;
    }

    public int getEnergyStored() {
        return Mth.clamp((int)this.getEnergyData(), (int)0, (int)this.getMaxEnergyStored());
    }

    protected abstract int getMaxReceive();

    protected abstract int getMaxExtract();

    public boolean canExtract() {
        return this.getMaxExtract() > 0;
    }

    public boolean canReceive() {
        return this.getMaxReceive() > 0;
    }

    protected abstract void setEnergyData(int var1);

    protected abstract int getEnergyData();

    protected void onReceived(int energy, boolean simulate) {
    }

    protected void onExtracted(int energy, boolean simulate) {
    }

    protected void onChanged() {
    }
}

