/*
 * Decompiled with CFR 0.152.
 */
package moe.wolfgirl.powerfuljs.custom.forge_energy;

import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.type.RecordTypeInfo;
import dev.latvian.mods.rhino.type.TypeInfo;
import moe.wolfgirl.powerfuljs.custom.base.CapabilityBuilder;
import moe.wolfgirl.powerfuljs.custom.base.info.BlockContext;
import moe.wolfgirl.powerfuljs.utils.MCID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class ConstantEnergy
implements IEnergyStorage {
    public static final ResourceLocation ID = MCID.create("constant_energy");
    public static final CapabilityBuilder<BlockContext, IEnergyStorage> BLOCK = CapabilityBuilder.create(ID, Capabilities.EnergyStorage.BLOCK, (TypeInfo)Configuration.TYPE_INFO, ConstantEnergy::wraps);
    public static final CapabilityBuilder<BlockEntity, IEnergyStorage> BLOCK_ENTITY = CapabilityBuilder.create(ID, Capabilities.EnergyStorage.BLOCK, (TypeInfo)Configuration.TYPE_INFO, ConstantEnergy::wraps);
    public static final CapabilityBuilder<Entity, IEnergyStorage> ENTITY = CapabilityBuilder.create(ID, Capabilities.EnergyStorage.ENTITY, (TypeInfo)Configuration.TYPE_INFO, ConstantEnergy::wraps);
    public static final CapabilityBuilder<ItemStack, IEnergyStorage> ITEM = CapabilityBuilder.create(ID, Capabilities.EnergyStorage.ITEM, (TypeInfo)Configuration.TYPE_INFO, ConstantEnergy::wraps);
    private final int maxExtract;
    private final int maxReceive;

    public static <O> CapabilityBuilder.CapabilityFactory<O, IEnergyStorage> wraps(Context ctx, Object configuration) {
        Configuration c = (Configuration)Configuration.TYPE_INFO.wrap(ctx, configuration, (TypeInfo)Configuration.TYPE_INFO);
        return object -> new ConstantEnergy(c.maxExtract, c.maxReceive);
    }

    public ConstantEnergy(int maxExtract, int maxReceive) {
        this.maxExtract = maxExtract;
        this.maxReceive = maxReceive;
    }

    public int receiveEnergy(int toReceive, boolean simulate) {
        return Math.min(toReceive, this.maxReceive);
    }

    public int extractEnergy(int toExtract, boolean simulate) {
        return Math.min(toExtract, this.maxExtract);
    }

    public int getEnergyStored() {
        return this.maxExtract;
    }

    public int getMaxEnergyStored() {
        return this.maxExtract + this.maxReceive;
    }

    public boolean canExtract() {
        return this.maxExtract > 0;
    }

    public boolean canReceive() {
        return this.maxReceive > 0;
    }

    public record Configuration(int maxExtract, int maxReceive) {
        public static final RecordTypeInfo TYPE_INFO = (RecordTypeInfo)TypeInfo.of(Configuration.class);
    }
}

