/*
 * Decompiled with CFR 0.152.
 */
package moe.wolfgirl.powerfuljs.custom.fluid_item;

import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.type.RecordTypeInfo;
import dev.latvian.mods.rhino.type.TypeInfo;
import java.util.function.Predicate;
import moe.wolfgirl.powerfuljs.custom.DataComponents;
import moe.wolfgirl.powerfuljs.custom.base.CapabilityBuilder;
import moe.wolfgirl.powerfuljs.custom.fluid.storage.FixedFluidTank;
import moe.wolfgirl.powerfuljs.serde.FluidContent;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.fluids.crafting.FluidIngredient;
import org.jetbrains.annotations.NotNull;

public class FixedItemFluidTank
extends FixedFluidTank
implements IFluidHandlerItem {
    public static final CapabilityBuilder<ItemStack, IFluidHandlerItem> ITEM = CapabilityBuilder.create(ID, Capabilities.FluidHandler.ITEM, (TypeInfo)Configuration.TYPE_INFO, FixedItemFluidTank::wrapsItem);
    private ItemStack parent;
    private final ItemStack onEmptyTransform;
    private final ItemTransformRule.FullRule[] onFullTransform;

    public static CapabilityBuilder.CapabilityFactory<ItemStack, IFluidHandlerItem> wrapsItem(Context ctx, Object configuration) {
        ItemTransformRule.FullRule[] onFullTransform;
        ItemStack onEmptyTransform;
        Configuration c = (Configuration)Configuration.TYPE_INFO.wrap(ctx, configuration, (TypeInfo)Configuration.TYPE_INFO);
        if (c.changeItemWhen != null) {
            onEmptyTransform = c.changeItemWhen.empty;
            onFullTransform = c.changeItemWhen.full;
        } else {
            onFullTransform = null;
            onEmptyTransform = null;
        }
        return object -> new FixedItemFluidTank(c.maxExtract, c.maxReceive, c.capacity, (Predicate<FluidStack>)c.validator, onEmptyTransform, onFullTransform, (ItemStack)object);
    }

    protected FixedItemFluidTank(int maxExtract, int maxReceive, int capacity, Predicate<FluidStack> validator, ItemStack onEmptyTransform, ItemTransformRule.FullRule[] onFullTransform, ItemStack parent) {
        super(maxExtract, maxReceive, capacity, validator);
        this.parent = parent;
        this.onEmptyTransform = onEmptyTransform;
        this.onFullTransform = onFullTransform;
    }

    @Override
    protected FluidStack getFluidData() {
        return ((FluidContent)this.parent.getOrDefault(DataComponents.FLUID, (Object)FluidContent.EMPTY)).fluidStack();
    }

    @Override
    protected void setFluidData(FluidStack fluidStack) {
        this.parent.set(DataComponents.FLUID, (Object)(fluidStack.isEmpty() ? FluidContent.EMPTY : new FluidContent(fluidStack)));
    }

    @Override
    @NotNull
    public FluidStack drain(int maxDrain, @NotNull IFluidHandler.FluidAction action) {
        FluidStack drained = super.drain(maxDrain, action);
        if (this.onEmptyTransform != null && this.getFluidData().isEmpty()) {
            if (this.onEmptyTransform.isEmpty()) {
                this.parent.shrink(1);
            } else {
                this.parent = this.onEmptyTransform.copy();
            }
        }
        return drained;
    }

    @Override
    public int fill(@NotNull FluidStack resource, @NotNull IFluidHandler.FluidAction action) {
        int filled = super.fill(resource, action);
        FluidStack fluid = this.getFluid();
        if (this.onFullTransform != null && fluid.getAmount() >= this.getCapacity()) {
            for (ItemTransformRule.FullRule fullRule : this.onFullTransform) {
                if (!fullRule.fluid.test(fluid)) continue;
                this.parent = fullRule.item.copy();
                break;
            }
        }
        return filled;
    }

    @NotNull
    public ItemStack getContainer() {
        return this.parent;
    }

    public record Configuration(int capacity, int maxExtract, int maxReceive, FluidIngredient validator, ItemTransformRule changeItemWhen) {
        public static final RecordTypeInfo TYPE_INFO = (RecordTypeInfo)TypeInfo.of(Configuration.class);
    }

    public record ItemTransformRule(ItemStack empty, FullRule[] full) {

        public record FullRule(FluidIngredient fluid, ItemStack item) {
        }
    }
}

