/*
 * Decompiled with CFR 0.152.
 */
package moe.wolfgirl.powerfuljs.custom.fluid.storage;

import java.util.function.Predicate;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public abstract class ProcessingFluidTank
implements IFluidHandler {
    protected final Predicate<FluidStack> inputValidator;
    protected final Predicate<FluidStack> outputValidator;

    protected ProcessingFluidTank(Predicate<FluidStack> inputValidator, Predicate<FluidStack> outputValidator) {
        this.inputValidator = inputValidator;
        this.outputValidator = outputValidator;
    }

    public int getTanks() {
        return 2;
    }

    @NotNull
    public FluidStack getFluidInTank(int tank) {
        return tank == 0 ? this.getInputFluidData() : this.getOutputFluidData();
    }

    public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
        Predicate<FluidStack> validator = tank == 0 ? this.inputValidator : this.outputValidator;
        return validator == null || validator.test(stack);
    }

    public int fill(@NotNull FluidStack resource, @NotNull IFluidHandler.FluidAction action) {
        return this.fill(resource, action, 0);
    }

    public int fill(@NotNull FluidStack resource, @NotNull IFluidHandler.FluidAction action, int tank) {
        int maxReceive;
        if (resource.isEmpty() || !this.isFluidValid(tank, resource)) {
            return 0;
        }
        FluidStack tankFluid = this.getFluidInTank(tank);
        int capacity = this.getTankCapacity(tank);
        int n = maxReceive = tank == 1 ? resource.getAmount() : Math.min(resource.getAmount(), this.getMaxReceive());
        if (action.simulate()) {
            if (tankFluid.isEmpty()) {
                return Math.min(capacity, maxReceive);
            }
            if (!FluidStack.isSameFluidSameComponents((FluidStack)tankFluid, (FluidStack)resource)) {
                return 0;
            }
            return Math.min(capacity - tankFluid.getAmount(), maxReceive);
        }
        if (tankFluid.isEmpty()) {
            FluidStack received = resource.copyWithAmount(Math.min(capacity, maxReceive));
            if (tank == 0) {
                this.setInputFluidData(received);
            } else {
                this.setOutputFluidData(received);
            }
            this.onReceived(received.getAmount());
            this.onChanged();
            return received.getAmount();
        }
        if (!FluidStack.isSameFluidSameComponents((FluidStack)tankFluid, (FluidStack)resource)) {
            return 0;
        }
        int filled = Math.min(capacity - tankFluid.getAmount(), maxReceive);
        if (filled > 0) {
            FluidStack filledStack = tankFluid.copyWithAmount(filled + tankFluid.getAmount());
            if (tank == 0) {
                this.setInputFluidData(filledStack);
            } else {
                this.setOutputFluidData(filledStack);
            }
            this.onReceived(filled);
            this.onChanged();
        }
        return filled;
    }

    @NotNull
    public FluidStack drain(@NotNull FluidStack resource, @NotNull IFluidHandler.FluidAction action) {
        if (resource.isEmpty() || !FluidStack.isSameFluidSameComponents((FluidStack)this.getOutputFluidData(), (FluidStack)resource)) {
            return FluidStack.EMPTY;
        }
        return this.drain(resource.getAmount(), action);
    }

    @NotNull
    public FluidStack drain(int maxDrain, @NotNull IFluidHandler.FluidAction action) {
        return this.drain(maxDrain, action, 1);
    }

    @NotNull
    public FluidStack drain(int maxDrain, @NotNull IFluidHandler.FluidAction action, int tank) {
        FluidStack tankFluid = this.getFluidInTank(tank);
        int drained = tank == 0 ? maxDrain : Math.min(this.getMaxExtract(), maxDrain);
        drained = Math.min(tankFluid.getAmount(), drained);
        if (action.execute() && drained > 0) {
            FluidStack drainedStack = tankFluid.copyWithAmount(tankFluid.getAmount() - drained);
            if (tank == 0) {
                this.setInputFluidData(drainedStack);
            } else {
                this.setOutputFluidData(drainedStack);
            }
            this.onExtracted(drained);
            this.onChanged();
        }
        return tankFluid.copyWithAmount(drained);
    }

    protected abstract FluidStack getInputFluidData();

    protected abstract FluidStack getOutputFluidData();

    protected abstract void setInputFluidData(FluidStack var1);

    protected abstract void setOutputFluidData(FluidStack var1);

    protected abstract int getMaxReceive();

    protected abstract int getMaxExtract();

    protected void onReceived(int amount) {
    }

    protected void onExtracted(int extracted) {
    }

    protected void onChanged() {
    }
}

