/*
 * Decompiled with CFR 0.152.
 */
package moe.wolfgirl.powerfuljs.custom.fluid.storage;

import java.util.function.Predicate;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.IFluidTank;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public abstract class BaseFluidTank
implements IFluidHandler,
IFluidTank {
    protected final Predicate<FluidStack> validator;

    protected BaseFluidTank(Predicate<FluidStack> validator) {
        this.validator = validator;
    }

    public final int getTanks() {
        return 1;
    }

    @NotNull
    public final FluidStack getFluidInTank(int tank) {
        return this.getFluid();
    }

    @NotNull
    public final FluidStack getFluid() {
        return this.getFluidData();
    }

    public int getFluidAmount() {
        return this.getFluid().getAmount();
    }

    public final int getTankCapacity(int tank) {
        return this.getCapacity();
    }

    public final boolean isFluidValid(int tank, @NotNull FluidStack stack) {
        return this.isFluidValid(stack);
    }

    public boolean isFluidValid(@NotNull FluidStack stack) {
        return this.validator == null || this.validator.test(stack);
    }

    public int fill(@NotNull FluidStack resource, @NotNull IFluidHandler.FluidAction action) {
        return this.fill(resource, action, false);
    }

    public int fill(@NotNull FluidStack resource, @NotNull IFluidHandler.FluidAction action, boolean forced) {
        int maxReceive;
        if (resource.isEmpty() || !this.isFluidValid(resource)) {
            return 0;
        }
        FluidStack tankFluid = this.getFluid();
        int capacity = this.getCapacity();
        int n = maxReceive = forced ? resource.getAmount() : Math.min(resource.getAmount(), this.getMaxReceive());
        if (action.simulate()) {
            if (tankFluid.isEmpty()) {
                return Math.min(capacity, maxReceive);
            }
            if (!FluidStack.isSameFluidSameComponents((FluidStack)tankFluid, (FluidStack)resource)) {
                return 0;
            }
            return Math.min(capacity - tankFluid.getAmount(), maxReceive);
        }
        if (tankFluid.isEmpty()) {
            FluidStack received = resource.copyWithAmount(Math.min(capacity, maxReceive));
            this.setFluidData(received);
            this.onReceived(received.getAmount());
            this.onChanged();
            return received.getAmount();
        }
        if (!FluidStack.isSameFluidSameComponents((FluidStack)tankFluid, (FluidStack)resource)) {
            return 0;
        }
        int filled = Math.min(capacity - tankFluid.getAmount(), maxReceive);
        if (filled > 0) {
            this.setFluidData(tankFluid.copyWithAmount(filled + tankFluid.getAmount()));
            this.onReceived(filled);
            this.onChanged();
        }
        return filled;
    }

    @NotNull
    public FluidStack drain(@NotNull FluidStack resource, @NotNull IFluidHandler.FluidAction action) {
        if (resource.isEmpty() || !FluidStack.isSameFluidSameComponents((FluidStack)resource, (FluidStack)this.getFluid())) {
            return FluidStack.EMPTY;
        }
        return this.drain(resource.getAmount(), action);
    }

    @NotNull
    public FluidStack drain(int maxDrain, @NotNull IFluidHandler.FluidAction action) {
        return this.drain(maxDrain, action, false);
    }

    @NotNull
    public FluidStack drain(int maxDrain, @NotNull IFluidHandler.FluidAction action, boolean forced) {
        FluidStack tankFluid = this.getFluid();
        int drained = forced ? maxDrain : Math.min(this.getMaxExtract(), maxDrain);
        drained = Math.min(tankFluid.getAmount(), drained);
        if (action.execute() && drained > 0) {
            this.setFluidData(tankFluid.copyWithAmount(tankFluid.getAmount() - drained));
            this.onExtracted(drained);
            this.onChanged();
        }
        return tankFluid.copyWithAmount(drained);
    }

    protected abstract FluidStack getFluidData();

    protected abstract void setFluidData(FluidStack var1);

    protected abstract int getMaxExtract();

    protected abstract int getMaxReceive();

    protected void onReceived(int amount) {
    }

    protected void onExtracted(int extracted) {
    }

    protected void onChanged() {
    }
}

