/*
 * Decompiled with CFR 0.152.
 */
package moe.wolfgirl.powerfuljs.custom.fluid;

import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.type.RecordTypeInfo;
import dev.latvian.mods.rhino.type.TypeInfo;
import moe.wolfgirl.powerfuljs.custom.base.CapabilityBuilder;
import moe.wolfgirl.powerfuljs.custom.base.info.BlockContext;
import moe.wolfgirl.powerfuljs.utils.MCID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public class ConstantFluid
implements IFluidHandler {
    public static final ResourceLocation ID = MCID.create("constant_fluid");
    public static final CapabilityBuilder<BlockContext, IFluidHandler> BLOCK = CapabilityBuilder.create(ID, Capabilities.FluidHandler.BLOCK, (TypeInfo)Configuration.TYPE_INFO, ConstantFluid::wraps);
    public static final CapabilityBuilder<BlockEntity, IFluidHandler> BLOCK_ENTITY = CapabilityBuilder.create(ID, Capabilities.FluidHandler.BLOCK, (TypeInfo)Configuration.TYPE_INFO, ConstantFluid::wraps);
    public static final CapabilityBuilder<Entity, IFluidHandler> ENTITY = CapabilityBuilder.create(ID, Capabilities.FluidHandler.ENTITY, (TypeInfo)Configuration.TYPE_INFO, ConstantFluid::wraps);
    private final FluidStack content;
    private final int capacity;
    private final int maxReceive;

    public static <O> CapabilityBuilder.CapabilityFactory<O, IFluidHandler> wraps(Context ctx, Object configuration) {
        Configuration c = (Configuration)Configuration.TYPE_INFO.wrap(ctx, configuration, (TypeInfo)Configuration.TYPE_INFO);
        return object -> new ConstantFluid(c.content, c.maxReceive);
    }

    public ConstantFluid(FluidStack content, int maxReceive) {
        if (content.isEmpty()) {
            throw new IllegalArgumentException("Content can't be empty.");
        }
        this.content = content;
        this.capacity = content.getAmount() + maxReceive;
        this.maxReceive = maxReceive;
    }

    public int getTanks() {
        return 1;
    }

    @NotNull
    public FluidStack getFluidInTank(int tank) {
        return this.content.copy();
    }

    public int getTankCapacity(int tank) {
        return this.capacity;
    }

    public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
        return FluidStack.isSameFluidSameComponents((FluidStack)this.content, (FluidStack)stack);
    }

    public int fill(@NotNull FluidStack resource, @NotNull IFluidHandler.FluidAction action) {
        if (resource.isEmpty()) {
            return 0;
        }
        return Math.min(this.maxReceive, resource.getAmount());
    }

    @NotNull
    public FluidStack drain(@NotNull FluidStack resource, @NotNull IFluidHandler.FluidAction action) {
        if (resource.isEmpty()) {
            return FluidStack.EMPTY;
        }
        return this.content.copyWithAmount(Math.min(resource.getAmount(), this.content.getAmount()));
    }

    @NotNull
    public FluidStack drain(int maxDrain, @NotNull IFluidHandler.FluidAction action) {
        if (maxDrain <= 0) {
            return FluidStack.EMPTY;
        }
        return this.content.copyWithAmount(Math.min(this.content.getAmount(), maxDrain));
    }

    public record Configuration(FluidStack content, int maxReceive) {
        public static final RecordTypeInfo TYPE_INFO = (RecordTypeInfo)TypeInfo.of(Configuration.class);
    }
}

