/*
 * Decompiled with CFR 0.152.
 */
package moe.wolfgirl.powerfuljs.custom.attachment;

import com.mojang.serialization.Codec;
import java.util.function.Supplier;
import moe.wolfgirl.powerfuljs.custom.attachment.AttachmentBuilder;
import net.minecraft.resources.ResourceLocation;

public class PrimitiveTypes {

    public static class BoolType
    extends AttachmentBuilder<Boolean> {
        public BoolType(ResourceLocation id) {
            super(id);
            this.typeClass = Boolean.class;
            this.defaultGetter = () -> false;
            this.codec = Codec.BOOL;
        }

        @Override
        public AttachmentBuilder<Boolean> defaultGetter(Supplier<Boolean> defaultGetter) {
            return super.defaultGetter(defaultGetter);
        }
    }

    public static class StringType
    extends AttachmentBuilder<String> {
        public StringType(ResourceLocation id) {
            super(id);
            this.typeClass = String.class;
            this.defaultGetter = () -> "";
            this.codec = Codec.STRING;
        }

        @Override
        public AttachmentBuilder<String> defaultGetter(Supplier<String> defaultGetter) {
            return super.defaultGetter(defaultGetter);
        }
    }

    public static class FloatType
    extends AttachmentBuilder<Float> {
        public FloatType(ResourceLocation id) {
            super(id);
            this.typeClass = Float.class;
            this.defaultGetter = () -> Float.valueOf(0.0f);
            this.codec = Codec.FLOAT;
        }

        @Override
        public AttachmentBuilder<Float> defaultGetter(Supplier<Float> defaultGetter) {
            return super.defaultGetter(defaultGetter);
        }
    }

    public static class IntegerType
    extends AttachmentBuilder<Integer> {
        public IntegerType(ResourceLocation id) {
            super(id);
            this.typeClass = Integer.class;
            this.defaultGetter = () -> 0;
            this.codec = Codec.INT;
        }

        @Override
        public AttachmentBuilder<Integer> defaultGetter(Supplier<Integer> defaultGetter) {
            return super.defaultGetter(defaultGetter);
        }
    }

    public static class ObjectType
    extends AttachmentBuilder<Object> {
        public ObjectType(ResourceLocation id) {
            super(id);
        }

        @Override
        public AttachmentBuilder<Object> defaultGetter(Supplier<Object> defaultGetter) {
            return super.defaultGetter(defaultGetter);
        }
    }
}

