/*
 * Decompiled with CFR 0.152.
 */
package moe.wolfgirl.powerfuljs.custom;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import moe.wolfgirl.powerfuljs.utils.MCID;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.capabilities.BaseCapability;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.EntityCapability;
import net.neoforged.neoforge.capabilities.ItemCapability;

public class CapabilityJS<B extends BaseCapability<?, ?>> {
    public static final CapabilityJS<BlockCapability<?, ?>> BLOCK = new CapabilityJS(BlockCapability.class);
    public static final CapabilityJS<ItemCapability<?, ?>> ITEM = new CapabilityJS(ItemCapability.class);
    public static final CapabilityJS<EntityCapability<?, ?>> ENTITY = new CapabilityJS(EntityCapability.class);
    private final Map<ResourceLocation, B> registry = new HashMap<ResourceLocation, B>();
    private final Class<?> baseClass;

    public CapabilityJS(Class<?> baseClass) {
        this.baseClass = baseClass;
    }

    public void register(B capability) {
        this.registry.put(capability.name(), capability);
    }

    public B wrap(Object o) {
        if (this.baseClass.isInstance(o)) {
            return (B)((BaseCapability)o);
        }
        ResourceLocation rl = MCID.of(o, "neoforge");
        BaseCapability cap = (BaseCapability)this.registry.get(rl);
        if (cap == null) {
            throw new IllegalArgumentException("Could not found capability with key %s!".formatted(rl));
        }
        return (B)cap;
    }

    public Stream<ResourceLocation> getKeys() {
        return this.registry.keySet().stream();
    }

    public Stream<B> getCapabilities() {
        return this.registry.values().stream();
    }

    public static void init() {
        for (BlockCapability blockCapability : BlockCapability.getAll()) {
            BLOCK.register(blockCapability);
        }
        for (ItemCapability itemCapability : ItemCapability.getAll()) {
            ITEM.register(itemCapability);
        }
        for (EntityCapability entityCapability : EntityCapability.getAll()) {
            ENTITY.register(entityCapability);
        }
    }
}

