/*
 * Decompiled with CFR 0.152.
 */
package bagu_chan.bagus_lib.entity.goal;

import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;

public class ManyAnimateAttackGoal
extends MeleeAttackGoal {
    protected boolean attack;
    public int attackTicks;
    protected final int[] actionPoints;
    protected final int attackLength;
    protected int maxAttackLength;
    protected int currentAttackLength;

    public ManyAnimateAttackGoal(PathfinderMob attacker, double speed, int[] actionPoints, int attackLength) {
        this(attacker, speed, actionPoints, attackLength, true);
    }

    public ManyAnimateAttackGoal(PathfinderMob attacker, double speed, int[] actionPoints, int attackLength, boolean longPath) {
        super(attacker, speed, longPath);
        this.actionPoints = actionPoints;
        this.attackLength = attackLength;
        this.maxAttackLength = actionPoints.length;
    }

    public void start() {
        super.start();
        this.attackTicks = 0;
    }

    public void stop() {
        super.stop();
        this.attack = false;
        this.mob.setAggressive(false);
    }

    public boolean canContinueToUse() {
        LivingEntity livingentity = this.mob.getTarget();
        return super.canContinueToUse() || livingentity != null && livingentity.isAlive() && this.attack;
    }

    protected void checkAndPerformAttack(LivingEntity target) {
        if (this.isTimeToAttack()) {
            if (this.canPerformAttack(target)) {
                this.doAttack(target);
            }
            if (this.currentAttackLength < this.maxAttackLength - 1) {
                ++this.currentAttackLength;
            }
        } else if (this.attackTicks >= this.attackLength) {
            this.resetAttackCooldown();
            this.attack = false;
        } else if (!this.attack) {
            if (!this.canPerformAttack(target)) {
                this.resetAttackCooldown();
            } else {
                this.attack = true;
                this.doAnimation();
            }
        }
        this.attackTicks = this.attack ? Mth.clamp((int)(this.attackTicks + 1), (int)0, (int)this.attackLength) : 0;
    }

    protected boolean canPerformAttack(LivingEntity target) {
        return this.mob.isWithinMeleeAttackRange(target) && this.mob.getSensing().hasLineOfSight((Entity)target);
    }

    protected void doAnimation() {
        this.mob.level().broadcastEntityEvent((Entity)this.mob, (byte)4);
    }

    protected void doAttack(LivingEntity living) {
        this.mob.doHurtTarget((Entity)living);
    }

    protected void resetAttackCooldown() {
        this.currentAttackLength = 0;
        this.attackTicks = 0;
        this.attack = false;
    }

    protected boolean isTimeToAttack() {
        return this.attackTicks == this.actionPoints[this.currentAttackLength];
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }
}

