/*
 * Decompiled with CFR 0.152.
 */
package bagu_chan.bagus_lib.command;

import bagu_chan.bagus_lib.client.dialog.DialogType;
import bagu_chan.bagus_lib.message.DialogMessage;
import bagu_chan.bagus_lib.message.RemoveAllDialogMessage;
import bagu_chan.bagus_lib.register.DialogDataRegister;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceKeyArgument;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.PacketDistributor;

public class DialogCommand {
    private static final DynamicCommandExceptionType ERROR_INVALID_FEATURE = new DynamicCommandExceptionType(p_212392_ -> Component.translatable((String)"commands.place.feature.invalid", (Object[])new Object[]{p_212392_}));

    public static void register(CommandDispatcher<CommandSourceStack> p_138061_, CommandBuildContext p_214450_) {
        LiteralCommandNode literalcommandnode = p_138061_.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"bagus_lib").requires(p_136627_ -> p_136627_.hasPermission(2))).then(Commands.literal((String)"dialog").then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"dialog_type", (ArgumentType)ResourceKeyArgument.key(DialogDataRegister.REGISTRY_KEY)).executes(p_248155_ -> {
            Collection collection = EntityArgument.getPlayers((CommandContext)p_248155_, (String)"targets");
            if (!collection.isEmpty()) {
                DialogCommand.sendDialogMessage((CommandSourceStack)p_248155_.getSource(), collection, DialogCommand.getDialogType((CommandContext<CommandSourceStack>)p_248155_, "dialog_type"));
            }
            return collection.size();
        })))));
        LiteralCommandNode literalcommandnode4 = p_138061_.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"bagus_lib").requires(p_136627_ -> p_136627_.hasPermission(2))).then(Commands.literal((String)"remove_all_dialog").then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).executes(p_248155_ -> {
            Collection collection = EntityArgument.getPlayers((CommandContext)p_248155_, (String)"targets");
            if (!collection.isEmpty()) {
                DialogCommand.sendRemoveAllDialogMessage((CommandSourceStack)p_248155_.getSource(), collection);
            }
            return collection.size();
        }))));
    }

    public static Holder.Reference<DialogType> getDialogType(CommandContext<CommandSourceStack> p_249310_, String p_250729_) throws CommandSyntaxException {
        return DialogCommand.resolveKey(p_249310_, p_250729_, DialogDataRegister.REGISTRY_KEY, ERROR_INVALID_FEATURE);
    }

    private static <T> Registry<T> getRegistry(CommandContext<CommandSourceStack> p_212379_, ResourceKey<? extends Registry<T>> p_212380_) {
        return ((CommandSourceStack)p_212379_.getSource()).getServer().registryAccess().registryOrThrow(p_212380_);
    }

    private static <T> ResourceKey<DialogType> getRegistryKey(CommandContext<CommandSourceStack> p_212374_, String p_212375_, ResourceKey<Registry<DialogType>> p_212376_, DynamicCommandExceptionType p_212377_) throws CommandSyntaxException {
        ResourceKey resourcekey = (ResourceKey)p_212374_.getArgument(p_212375_, ResourceKey.class);
        Optional optional = resourcekey.cast(p_212376_);
        return (ResourceKey)optional.orElseThrow(() -> p_212377_.create((Object)resourcekey));
    }

    private static <T> Holder.Reference<DialogType> resolveKey(CommandContext<CommandSourceStack> p_248662_, String p_252172_, ResourceKey<Registry<DialogType>> p_249701_, DynamicCommandExceptionType p_249790_) throws CommandSyntaxException {
        ResourceKey<DialogType> resourcekey = DialogCommand.getRegistryKey(p_248662_, p_252172_, p_249701_, p_249790_);
        return (Holder.Reference)DialogCommand.getRegistry(p_248662_, p_249701_).getHolder(resourcekey).orElseThrow(() -> p_249790_.create((Object)resourcekey.location()));
    }

    private static void sendRemoveAllDialogMessage(CommandSourceStack p_250209_, Collection<ServerPlayer> p_252344_) {
        for (ServerPlayer serverplayer : p_252344_) {
            PacketDistributor.sendToPlayer((ServerPlayer)serverplayer, (CustomPacketPayload)new RemoveAllDialogMessage(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        p_250209_.sendSystemMessage((Component)Component.translatable((String)"command.bagus_lib.remove_all_dialog"));
    }

    private static void sendDialogMessage(CommandSourceStack p_250209_, Collection<ServerPlayer> p_252344_, Holder.Reference<DialogType> p_249416_) {
        for (ServerPlayer serverplayer : p_252344_) {
            PacketDistributor.sendToPlayer((ServerPlayer)serverplayer, new DialogMessage("Command", (DialogType)p_249416_.value()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        p_250209_.sendSystemMessage((Component)Component.translatable((String)"command.bagus_lib.dialog"));
    }
}

