/*
 * Decompiled with CFR 0.152.
 */
package cc.unilock.deslabification;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.SlabBlock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Deslabification {
    public static final String MOD_ID = "deslabification";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"deslabification");

    public static void process(ImmutableMultimap.Builder<RecipeType<?>, RecipeHolder<?>> builder1, ImmutableMap.Builder<ResourceLocation, RecipeHolder<?>> builder2, ResourceLocation blockToSlabId, Recipe<?> recipe) {
        BlockItem bi;
        ShapedRecipe shaped;
        Item item;
        if (recipe instanceof ShapedRecipe && (item = (shaped = (ShapedRecipe)recipe).getResultItem(null).getItem()) instanceof BlockItem && (item = (bi = (BlockItem)item).getBlock()) instanceof SlabBlock) {
            List<Ingredient> ingredients;
            SlabBlock slab = (SlabBlock)item;
            if (shaped.getResultItem(null).getCount() == 6 && (ingredients = shaped.getIngredients().stream().filter(i -> !i.isEmpty()).toList()).size() == 3) {
                if (ingredients.stream().allMatch(arg_0 -> ((Ingredient)ingredients.getFirst()).equals(arg_0))) {
                    ItemStack[] inputs = ingredients.getFirst().getItems();
                    if (inputs.length == 0) {
                        LOGGER.error("[Deslabification] Attempted to process suspicious block-to-slab recipe, it will be skipped: " + blockToSlabId.toString());
                        return;
                    }
                    ItemStack input = inputs[0];
                    ResourceLocation blockId = BuiltInRegistries.ITEM.getKey((Object)input.getItem());
                    ResourceLocation slabId = BuiltInRegistries.BLOCK.getKey((Object)slab);
                    ResourceLocation recipeId = ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)(blockId.getNamespace() + "_" + blockId.getPath() + "/" + slabId.getNamespace() + "_" + slabId.getPath()));
                    RecipeHolder recipeHolder = new RecipeHolder(recipeId, (Recipe)new ShapedRecipe("", CraftingBookCategory.BUILDING, ShapedRecipePattern.of(Map.of(Character.valueOf('#'), Ingredient.of((ItemLike[])new ItemLike[]{slab})), (String[])new String[]{"##"}), input));
                    builder1.put((Object)RecipeType.CRAFTING, (Object)recipeHolder);
                    builder2.put((Object)recipeId, (Object)recipeHolder);
                }
            }
        }
    }
}

