/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.everythingcopper;

import com.mojang.serialization.MapCodec;
import cy.jdkdigital.everythingcopper.common.condition.LazyCondition;
import cy.jdkdigital.everythingcopper.common.entity.CopperGolem;
import cy.jdkdigital.everythingcopper.event.EventHandler;
import cy.jdkdigital.everythingcopper.init.ModArmorMaterials;
import cy.jdkdigital.everythingcopper.init.ModBlockEntities;
import cy.jdkdigital.everythingcopper.init.ModBlocks;
import cy.jdkdigital.everythingcopper.init.ModDataComponents;
import cy.jdkdigital.everythingcopper.init.ModEffects;
import cy.jdkdigital.everythingcopper.init.ModEntities;
import cy.jdkdigital.everythingcopper.init.ModItems;
import cy.jdkdigital.everythingcopper.init.ModLootModifiers;
import cy.jdkdigital.everythingcopper.init.ModRecipeTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CarvedPumpkinBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="everythingcopper")
public class EverythingCopper {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MODID = "everythingcopper";
    public static final DeferredRegister<MapCodec<? extends ICondition>> CONDITION_CODECS = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.CONDITION_CODECS, (String)"everythingcopper");
    public static final DeferredHolder<MapCodec<? extends ICondition>, MapCodec<LazyCondition>> LAZY_CONDITION = CONDITION_CODECS.register("lazy", () -> LazyCondition.CODEC);

    public EverythingCopper(IEventBus modEventBus, ModContainer modContainer) {
        ModEffects.EFFECTS.register(modEventBus);
        ModItems.ITEMS.register(modEventBus);
        ModBlocks.BLOCKS.register(modEventBus);
        ModEntities.ENTITIES.register(modEventBus);
        ModBlockEntities.BLOCK_ENTITIES.register(modEventBus);
        ModLootModifiers.LOOT_SERIALIZERS.register(modEventBus);
        ModRecipeTypes.RECIPE_SERIALIZERS.register(modEventBus);
        ModDataComponents.DATA_COMPONENTS.register(modEventBus);
        ModArmorMaterials.ARMOR_MATERIALS.register(modEventBus);
        CONDITION_CODECS.register(modEventBus);
        modEventBus.addListener(this::onCommonSetup);
        modEventBus.addListener(EventHandler::onEntityAttributeCreate);
        modEventBus.addListener(EventHandler::buildContents);
    }

    public void onCommonSetup(FMLCommonSetupEvent event) {
        DispenserBlock.registerBehavior((ItemLike)Items.CARVED_PUMPKIN, (DispenseItemBehavior)new CopperGolemDispenserBehavior());
        DispenserBlock.registerBehavior((ItemLike)Items.JACK_O_LANTERN, (DispenseItemBehavior)new CopperGolemDispenserBehavior());
    }

    static class CopperGolemDispenserBehavior
    extends OptionalDispenseItemBehavior {
        CopperGolemDispenserBehavior() {
        }

        /*
         * Enabled aggressive block sorting
         */
        protected ItemStack execute(BlockSource pBlockSource, ItemStack pItem) {
            Item item;
            ServerLevel level = pBlockSource.level();
            Direction direction = (Direction)pBlockSource.state().getValue((Property)DispenserBlock.FACING);
            BlockPos blockpos = pBlockSource.pos().relative(direction);
            CarvedPumpkinBlock carvedpumpkinblock = (CarvedPumpkinBlock)Blocks.CARVED_PUMPKIN;
            if (level.isEmptyBlock(blockpos) && (item = pItem.getItem()) instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)item;
                if (carvedpumpkinblock.canSpawnGolem((LevelReader)level, blockpos) || CopperGolem.canSpawnGolem((LevelReader)level, blockpos)) {
                    if (!level.isClientSide) {
                        level.setBlock(blockpos, blockItem.getBlock().defaultBlockState(), 3);
                        level.gameEvent(null, (Holder)GameEvent.BLOCK_PLACE, blockpos);
                    }
                    pItem.shrink(1);
                    this.setSuccess(true);
                    return pItem;
                }
            }
            this.setSuccess(ArmorItem.dispenseArmor((BlockSource)pBlockSource, (ItemStack)pItem));
            return pItem;
        }
    }
}

