/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.routers.screen;

import com.benbenlaw.routers.block.RoutersBlocks;
import com.benbenlaw.routers.block.entity.ImporterBlockEntity;
import com.benbenlaw.routers.block.entity.MekanismCompat;
import com.benbenlaw.routers.screen.RoutersMenuTypes;
import com.benbenlaw.routers.screen.util.GhostSlot;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import org.jetbrains.annotations.NotNull;

public class ImporterMenu
extends AbstractContainerMenu {
    protected ImporterBlockEntity blockEntity;
    protected Level level;
    protected ContainerData data;
    protected Player player;
    protected BlockPos blockPos;
    public SimpleContainer filterInventory;

    public ImporterMenu(int containerID, Inventory inventory, FriendlyByteBuf extraData) {
        this(containerID, inventory, extraData.readBlockPos(), (ContainerData)new SimpleContainerData(2));
    }

    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    public ImporterMenu(int containerID, Inventory inventory, BlockPos blockPos, ContainerData data) {
        super((MenuType)RoutersMenuTypes.IMPORTER_MENU.get(), containerID);
        this.player = inventory.player;
        this.blockPos = blockPos;
        this.level = inventory.player.level();
        this.data = data;
        this.blockEntity = (ImporterBlockEntity)this.level.getBlockEntity(blockPos);
        this.filterInventory = new SimpleContainer(Objects.requireNonNull(this.blockEntity).getFilters().size()){

            public void setChanged() {
                super.setChanged();
                ImporterMenu.this.blockEntity.setChanged();
            }
        };
        for (int i = 0; i < this.blockEntity.getFilters().size(); ++i) {
            this.filterInventory.setItem(i, (ItemStack)this.blockEntity.getFilters().get(i));
        }
        for (int row = 0; row < 2; ++row) {
            for (int col = 0; col < 9; ++col) {
                GhostSlot slot = this.getGhostSlot(col, row);
                this.addSlot(slot);
            }
        }
        this.addPlayerInventory(inventory);
        this.addPlayerHotbar(inventory);
    }

    @NotNull
    private GhostSlot getGhostSlot(int col, int row) {
        ItemStack item;
        FluidStack fluid;
        int index = col + row * 9;
        GhostSlot slot = new GhostSlot((Container)this.filterInventory, index, 8 + col * 18, 20 + row * 18);
        if (this.blockEntity.getFluidFilters().size() > index && !(fluid = (FluidStack)this.blockEntity.getFluidFilters().get(index)).isEmpty()) {
            slot.setFluid(fluid);
        }
        if (this.blockEntity.getFilters().size() > index && !(item = (ItemStack)this.blockEntity.getFilters().get(index)).isEmpty()) {
            slot.setItem(item);
        }
        return slot;
    }

    public void updateFluids(List<FluidStack> fluids) {
        for (int i = 0; i < this.slots.size(); ++i) {
            Object object = this.slots.get(i);
            if (!(object instanceof GhostSlot)) continue;
            GhostSlot ghostSlot = (GhostSlot)((Object)object);
            FluidStack fluid = i < fluids.size() ? fluids.get(i) : FluidStack.EMPTY;
            ghostSlot.setFluid(fluid);
        }
    }

    public void updateChemicals(List<?> chemicals) {
        if (!ModList.get().isLoaded("mekanism")) {
            return;
        }
        for (int i = 0; i < this.slots.size(); ++i) {
            Object object = this.slots.get(i);
            if (!(object instanceof GhostSlot)) continue;
            GhostSlot ghostSlot = (GhostSlot)((Object)object);
            Object chemical = i < chemicals.size() ? chemicals.get(i) : MekanismCompat.EMPTY_CHEMICAL;
            ghostSlot.setChemical(chemical);
        }
    }

    public void removed(Player player) {
        super.removed(player);
        for (int i = 0; i < this.blockEntity.getFilters().size(); ++i) {
            this.blockEntity.getFilters().set(i, (Object)this.filterInventory.getItem(i));
        }
        this.blockEntity.setChanged();
    }

    public void clicked(int slotId, int dragType, ClickType clickType, Player player) {
        if (slotId < 0 || slotId >= this.slots.size()) {
            super.clicked(slotId, dragType, clickType, player);
            return;
        }
        Slot slot = (Slot)this.slots.get(slotId);
        if (slot instanceof GhostSlot) {
            GhostSlot ghostSlot = (GhostSlot)slot;
            ItemStack carried = player.containerMenu.getCarried();
            Optional fluid = FluidUtil.getFluidContained((ItemStack)carried);
            if (fluid.isPresent()) {
                this.blockEntity.getFilters().set(slotId, (Object)ItemStack.EMPTY);
                this.blockEntity.getFluidFilters().set(slotId, (Object)((FluidStack)fluid.get()));
                ghostSlot.set(ItemStack.EMPTY);
                ghostSlot.setFluid((FluidStack)fluid.get());
                if (ModList.get().isLoaded("mekanism")) {
                    NonNullList<?> chemicals = this.blockEntity.getChemicalFilters();
                    Object emptyChemical = MekanismCompat.EMPTY_CHEMICAL != null ? MekanismCompat.EMPTY_CHEMICAL : MekanismCompat.createChemicalStack();
                    chemicals.set(slotId, emptyChemical);
                    ghostSlot.setChemical(emptyChemical);
                }
            } else if (!carried.isEmpty()) {
                this.blockEntity.getFilters().set(slotId, (Object)carried.copyWithCount(1));
                this.blockEntity.getFluidFilters().set(slotId, (Object)FluidStack.EMPTY);
                ghostSlot.set(carried.copyWithCount(1));
                ghostSlot.setFluid(FluidStack.EMPTY);
                if (ModList.get().isLoaded("mekanism")) {
                    NonNullList<?> chemicals = this.blockEntity.getChemicalFilters();
                    Object emptyChemical = MekanismCompat.EMPTY_CHEMICAL != null ? MekanismCompat.EMPTY_CHEMICAL : MekanismCompat.createChemicalStack();
                    chemicals.set(slotId, emptyChemical);
                    ghostSlot.setChemical(emptyChemical);
                }
            } else {
                this.blockEntity.getFilters().set(slotId, (Object)ItemStack.EMPTY);
                this.blockEntity.getFluidFilters().set(slotId, (Object)FluidStack.EMPTY);
                ghostSlot.set(ItemStack.EMPTY);
                ghostSlot.setFluid(FluidStack.EMPTY);
                if (ModList.get().isLoaded("mekanism")) {
                    NonNullList<?> chemicals = this.blockEntity.getChemicalFilters();
                    Object emptyChemical = MekanismCompat.EMPTY_CHEMICAL != null ? MekanismCompat.EMPTY_CHEMICAL : MekanismCompat.createChemicalStack();
                    chemicals.set(slotId, emptyChemical);
                    ghostSlot.setChemical(emptyChemical);
                }
            }
            this.blockEntity.setChanged();
        }
        super.clicked(slotId, dragType, clickType, player);
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        return ItemStack.EMPTY;
    }

    public boolean stillValid(@NotNull Player player) {
        return ImporterMenu.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)player.level(), (BlockPos)this.blockPos), (Player)player, (Block)((Block)RoutersBlocks.IMPORTER_BLOCK.get()));
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.addSlot(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, 73 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 131));
        }
    }
}

