/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.casting.screen;

import com.benbenlaw.casting.block.entity.TankBlockEntity;
import com.benbenlaw.casting.item.CastingItems;
import com.benbenlaw.casting.network.payload.ClearTankPayload;
import com.benbenlaw.casting.network.payload.FluidMoverPayload;
import com.benbenlaw.casting.screen.SmelterMenu;
import com.benbenlaw.casting.screen.SolidifierScreen;
import com.benbenlaw.casting.screen.util.FluidStackWidget;
import com.benbenlaw.casting.screen.util.FuelTankFluidStackWidget;
import com.benbenlaw.core.util.MouseUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.network.PacketDistributor;

public class SmelterScreen
extends AbstractContainerScreen<SmelterMenu> {
    Level level;
    private BlockEntity fuelTankEntity;
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"casting", (String)"textures/gui/controller_gui.png");

    public SmelterScreen(SmelterMenu menu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)menu, inventory, component);
        this.level = menu.level;
        for (Direction direction : Direction.values()) {
            BlockEntity adjacentEntity = this.level.getBlockEntity(menu.blockEntity.getBlockPos().relative(direction));
            if (adjacentEntity instanceof TankBlockEntity) {
                TankBlockEntity tankBlockEntity = (TankBlockEntity)adjacentEntity;
                this.fuelTankEntity = this.level.getBlockEntity(tankBlockEntity.getBlockPos());
                break;
            }
            this.fuelTankEntity = null;
        }
    }

    protected void init() {
        super.init();
        this.addFluidWidgets();
    }

    public void addFluidWidgets() {
        this.addRenderableOnly((Renderable)new FluidStackWidget((Screen)this, ((SmelterMenu)this.getMenu()).blockEntity.TANK_1, this.leftPos + 136, this.topPos + 15, 14, 26));
        this.addRenderableOnly((Renderable)new FluidStackWidget((Screen)this, ((SmelterMenu)this.getMenu()).blockEntity.TANK_2, this.leftPos + 153, this.topPos + 15, 14, 26));
        this.addRenderableOnly((Renderable)new FluidStackWidget((Screen)this, ((SmelterMenu)this.getMenu()).blockEntity.TANK_3, this.leftPos + 136, this.topPos + 45, 14, 26));
        this.addRenderableOnly((Renderable)new FluidStackWidget((Screen)this, ((SmelterMenu)this.getMenu()).blockEntity.TANK_4, this.leftPos + 153, this.topPos + 45, 14, 26));
        FluidTank fuelTank = new FluidTank(0);
        BlockEntity blockEntity = this.fuelTankEntity;
        if (blockEntity instanceof TankBlockEntity) {
            TankBlockEntity tankBlockEntity = (TankBlockEntity)blockEntity;
            fuelTank = tankBlockEntity.FLUID_TANK;
        }
        if (fuelTank.getCapacity() != 0 && fuelTank.getFluidAmount() != 0) {
            this.addRenderableOnly((Renderable)new FuelTankFluidStackWidget((Screen)this, fuelTank, ((SmelterMenu)this.menu).blockEntity, this.leftPos + 112, this.topPos + 54, 16, 16));
        }
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        this.renderProgressBars(guiGraphics);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(TEXTURE, x, y, 0, 0, this.imageWidth, this.imageHeight);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderProgressBars(guiGraphics);
        FluidTank fuelTank = new FluidTank(0);
        BlockEntity blockEntity = this.fuelTankEntity;
        if (blockEntity instanceof TankBlockEntity) {
            TankBlockEntity tankBlockEntity = (TankBlockEntity)blockEntity;
            fuelTank = tankBlockEntity.FLUID_TANK;
        }
        if (fuelTank.getCapacity() == 0) {
            this.renderNoTank(guiGraphics, mouseX, mouseY, x, y);
        } else if (fuelTank.getFluidAmount() == 0) {
            this.renderEmptyTank(guiGraphics, mouseX, mouseY, x, y);
        }
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        this.renderWarning(guiGraphics, mouseX, mouseY);
    }

    private void renderProgressBars(GuiGraphics guiGraphics) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        for (int slot = 0; slot <= 14; ++slot) {
            int progress = ((SmelterMenu)this.menu).getScaledProgress(slot);
            int slotX = this.getSlotX(slot);
            int slotY = this.getSlotY(slot);
            guiGraphics.blit(TEXTURE, x + slotX - 1, y + slotY - 5, 176, 0, progress, 18);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        boolean hasShiftDown;
        boolean handled = super.mouseClicked(mouseX, mouseY, mouseButton);
        ItemStack heldItem = ((SmelterMenu)this.menu).getCarried();
        boolean isHoldingBucket = heldItem.is(CastingItems.FLUID_MOVER);
        int tankX_1 = this.leftPos + 136;
        int tankY_1 = this.topPos + 15;
        int tankX_2 = this.leftPos + 153;
        int tankY_2 = this.topPos + 15;
        int tankX_3 = this.leftPos + 136;
        int tankY_3 = this.topPos + 45;
        int tankX_4 = this.leftPos + 153;
        int tankY_4 = this.topPos + 45;
        int tankWidth = 14;
        int tankHeight = 26;
        if (MouseUtil.isMouseOver((double)mouseX, (double)mouseY, (int)tankX_1, (int)tankY_1, (int)tankWidth, (int)tankHeight)) {
            hasShiftDown = SolidifierScreen.hasShiftDown();
            if (isHoldingBucket) {
                PacketDistributor.sendToServer((CustomPacketPayload)new FluidMoverPayload(((SmelterMenu)this.menu).blockEntity.getBlockPos(), 1), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else {
                PacketDistributor.sendToServer((CustomPacketPayload)new ClearTankPayload(((SmelterMenu)this.menu).blockEntity.getBlockPos(), hasShiftDown, 1), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
        if (MouseUtil.isMouseOver((double)mouseX, (double)mouseY, (int)tankX_2, (int)tankY_2, (int)tankWidth, (int)tankHeight)) {
            hasShiftDown = SolidifierScreen.hasShiftDown();
            if (isHoldingBucket) {
                PacketDistributor.sendToServer((CustomPacketPayload)new FluidMoverPayload(((SmelterMenu)this.menu).blockEntity.getBlockPos(), 2), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else {
                PacketDistributor.sendToServer((CustomPacketPayload)new ClearTankPayload(((SmelterMenu)this.menu).blockEntity.getBlockPos(), hasShiftDown, 2), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
        if (MouseUtil.isMouseOver((double)mouseX, (double)mouseY, (int)tankX_3, (int)tankY_3, (int)tankWidth, (int)tankHeight)) {
            hasShiftDown = SolidifierScreen.hasShiftDown();
            if (isHoldingBucket) {
                PacketDistributor.sendToServer((CustomPacketPayload)new FluidMoverPayload(((SmelterMenu)this.menu).blockEntity.getBlockPos(), 3), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else {
                PacketDistributor.sendToServer((CustomPacketPayload)new ClearTankPayload(((SmelterMenu)this.menu).blockEntity.getBlockPos(), hasShiftDown, 3), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
        if (MouseUtil.isMouseOver((double)mouseX, (double)mouseY, (int)tankX_4, (int)tankY_4, (int)tankWidth, (int)tankHeight)) {
            hasShiftDown = SolidifierScreen.hasShiftDown();
            if (isHoldingBucket) {
                PacketDistributor.sendToServer((CustomPacketPayload)new FluidMoverPayload(((SmelterMenu)this.menu).blockEntity.getBlockPos(), 4), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else {
                PacketDistributor.sendToServer((CustomPacketPayload)new ClearTankPayload(((SmelterMenu)this.menu).blockEntity.getBlockPos(), hasShiftDown, 4), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
        return handled;
    }

    private void renderWarning(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int tankX_1 = this.leftPos + 136;
        int tankY_1 = this.topPos + 15;
        int tankX_2 = this.leftPos + 153;
        int tankY_2 = this.topPos + 15;
        int tankX_3 = this.leftPos + 136;
        int tankY_3 = this.topPos + 45;
        int tankX_4 = this.leftPos + 153;
        int tankY_4 = this.topPos + 45;
        int tankWidth = 14;
        int tankHeight = 26;
        if (MouseUtil.isMouseOver((double)mouseX, (double)mouseY, (int)tankX_1, (int)tankY_1, (int)tankWidth, (int)tankHeight) && SolidifierScreen.hasShiftDown()) {
            guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"gui.casting.buttons.dump_fluid").withStyle(ChatFormatting.RED), mouseX, mouseY - 14);
        }
        if (MouseUtil.isMouseOver((double)mouseX, (double)mouseY, (int)tankX_2, (int)tankY_2, (int)tankWidth, (int)tankHeight) && SolidifierScreen.hasShiftDown()) {
            guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"gui.casting.buttons.dump_fluid").withStyle(ChatFormatting.RED), mouseX, mouseY - 14);
        }
        if (MouseUtil.isMouseOver((double)mouseX, (double)mouseY, (int)tankX_3, (int)tankY_3, (int)tankWidth, (int)tankHeight) && SolidifierScreen.hasShiftDown()) {
            guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"gui.casting.buttons.dump_fluid").withStyle(ChatFormatting.RED), mouseX, mouseY - 14);
        }
        if (MouseUtil.isMouseOver((double)mouseX, (double)mouseY, (int)tankX_4, (int)tankY_4, (int)tankWidth, (int)tankHeight) && SolidifierScreen.hasShiftDown()) {
            guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"gui.casting.buttons.dump_fluid").withStyle(ChatFormatting.RED), mouseX, mouseY - 14);
        }
        if (MouseUtil.isMouseOver((double)mouseX, (double)mouseY, (int)tankX_1, (int)tankY_1, (int)tankWidth, (int)tankHeight) && !SolidifierScreen.hasShiftDown()) {
            guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"gui.casting.buttons.shift_dump_fluid").withStyle(ChatFormatting.RED), mouseX, mouseY - 14);
        }
        if (MouseUtil.isMouseOver((double)mouseX, (double)mouseY, (int)tankX_2, (int)tankY_2, (int)tankWidth, (int)tankHeight) && !SolidifierScreen.hasShiftDown()) {
            guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"gui.casting.buttons.shift_dump_fluid").withStyle(ChatFormatting.RED), mouseX, mouseY - 14);
        }
        if (MouseUtil.isMouseOver((double)mouseX, (double)mouseY, (int)tankX_3, (int)tankY_3, (int)tankWidth, (int)tankHeight) && !SolidifierScreen.hasShiftDown()) {
            guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"gui.casting.buttons.shift_dump_fluid").withStyle(ChatFormatting.RED), mouseX, mouseY - 14);
        }
        if (MouseUtil.isMouseOver((double)mouseX, (double)mouseY, (int)tankX_4, (int)tankY_4, (int)tankWidth, (int)tankHeight) && !SolidifierScreen.hasShiftDown()) {
            guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"gui.casting.buttons.shift_dump_fluid").withStyle(ChatFormatting.RED), mouseX, mouseY - 14);
        }
    }

    private int getSlotX(int slot) {
        switch (slot) {
            case 0: 
            case 5: 
            case 10: {
                return 12;
            }
            case 1: 
            case 6: 
            case 11: {
                return 31;
            }
            case 2: 
            case 7: 
            case 12: {
                return 50;
            }
            case 3: 
            case 8: 
            case 13: {
                return 69;
            }
            case 4: 
            case 9: 
            case 14: {
                return 88;
            }
        }
        return 0;
    }

    private int getSlotY(int slot) {
        if (slot >= 0 && slot <= 4) {
            return 20;
        }
        if (slot >= 5 && slot <= 9) {
            return 39;
        }
        if (slot >= 10 && slot <= 14) {
            return 58;
        }
        return 0;
    }

    private void renderNoTank(GuiGraphics guiGraphics, int mouseX, int mouseY, int x, int y) {
        if (MouseUtil.isMouseAboveArea((int)mouseX, (int)mouseY, (int)x, (int)y, (int)112, (int)54, (int)16, (int)16)) {
            guiGraphics.renderTooltip(this.font, (Component)Component.literal((String)"Place a Tank adjacent to the controller!").withStyle(ChatFormatting.RED), mouseX, mouseY);
        }
    }

    private void renderEmptyTank(GuiGraphics guiGraphics, int mouseX, int mouseY, int x, int y) {
        if (MouseUtil.isMouseAboveArea((int)mouseX, (int)mouseY, (int)x, (int)y, (int)112, (int)54, (int)16, (int)16)) {
            guiGraphics.renderTooltip(this.font, (Component)Component.literal((String)"Tank missing fuel!").withStyle(ChatFormatting.RED), mouseX, mouseY);
        }
    }
}

