/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.common.fakelevel;

import com.ldtteam.common.fakelevel.IFakeLevelLightProvider;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Difficulty;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.level.storage.WritableLevelData;

public class FakeLevelData
implements WritableLevelData {
    protected Supplier<LevelData> vanillaLevelData;
    protected final IFakeLevelLightProvider lightProvider;

    protected FakeLevelData(Supplier<LevelData> vanillaLevelData, IFakeLevelLightProvider lightProvider) {
        this.vanillaLevelData = vanillaLevelData;
        this.lightProvider = lightProvider;
    }

    public BlockPos getSpawnPos() {
        return BlockPos.ZERO;
    }

    public float getSpawnAngle() {
        return 0.0f;
    }

    public long getGameTime() {
        return this.vanillaLevelData.get().getGameTime();
    }

    public long getDayTime() {
        return this.lightProvider.forceOwnLightLevel() ? this.lightProvider.getDayTime() : this.vanillaLevelData.get().getDayTime();
    }

    public boolean isThundering() {
        return false;
    }

    public boolean isRaining() {
        return false;
    }

    public void setRaining(boolean p_78171_) {
    }

    public boolean isHardcore() {
        return false;
    }

    public GameRules getGameRules() {
        return this.vanillaLevelData.get().getGameRules();
    }

    public Difficulty getDifficulty() {
        return Difficulty.EASY;
    }

    public boolean isDifficultyLocked() {
        return true;
    }

    public void setSpawn(BlockPos pos, float angle) {
    }
}

