/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.common.config;

import com.ldtteam.common.config.AbstractConfiguration;
import com.ldtteam.common.config.ClientConfigHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.config.ConfigTracker;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class Configurations<CLIENT extends AbstractConfiguration, SERVER extends AbstractConfiguration, COMMON extends AbstractConfiguration> {
    private final ModConfig client;
    private final CLIENT clientConfig;
    private final ModConfig server;
    private final SERVER serverConfig;
    private final ModConfig common;
    private final COMMON commonConfig;
    private final AbstractConfiguration[] activeConfigs;

    public Configurations(ModContainer modContainer, IEventBus modBus, Function<ModConfigSpec.Builder, CLIENT> clientFactory, Function<ModConfigSpec.Builder, SERVER> serverFactory, Function<ModConfigSpec.Builder, COMMON> commonFactory) {
        ArrayList<AbstractConfiguration> configs = new ArrayList<AbstractConfiguration>();
        Pair<CLIENT, ModConfig> cli = this.createConfig(clientFactory, ModConfig.Type.CLIENT, modContainer, configs);
        this.client = (ModConfig)cli.getRight();
        this.clientConfig = (AbstractConfiguration)cli.getLeft();
        Pair<SERVER, ModConfig> ser = this.createConfig(serverFactory, ModConfig.Type.SERVER, modContainer, configs);
        this.server = (ModConfig)ser.getRight();
        this.serverConfig = (AbstractConfiguration)ser.getLeft();
        Pair<COMMON, ModConfig> com = this.createConfig(commonFactory, ModConfig.Type.COMMON, modContainer, configs);
        this.common = (ModConfig)com.getRight();
        this.commonConfig = (AbstractConfiguration)com.getLeft();
        this.activeConfigs = (AbstractConfiguration[])configs.toArray(AbstractConfiguration[]::new);
        modBus.addListener(ModConfigEvent.Loading.class, event -> this.onConfigLoad(event.getConfig()));
        modBus.addListener(ModConfigEvent.Reloading.class, event -> this.onConfigReload(event.getConfig()));
        if (FMLEnvironment.dist.isClient()) {
            ClientConfigHelper.registerClient(modContainer);
        }
    }

    private <T extends AbstractConfiguration> Pair<T, ModConfig> createConfig(Function<ModConfigSpec.Builder, T> factory, ModConfig.Type type, ModContainer modContainer, List<AbstractConfiguration> configs) {
        if (factory == null || type == ModConfig.Type.CLIENT && !FMLEnvironment.dist.isClient()) {
            return Pair.of(null, null);
        }
        Pair builtConfig = new ModConfigSpec.Builder().configure(factory);
        ModConfig modConfig = ConfigTracker.INSTANCE.registerConfig(type, (IConfigSpec)builtConfig.getRight(), modContainer);
        AbstractConfiguration config = (AbstractConfiguration)builtConfig.getLeft();
        configs.add(config);
        return Pair.of((Object)config, (Object)modConfig);
    }

    public CLIENT getClient() {
        return this.clientConfig;
    }

    public SERVER getServer() {
        return this.serverConfig;
    }

    public COMMON getCommon() {
        return this.commonConfig;
    }

    private void onConfigLoad(ModConfig modConfig) {
        if (this.client != null && modConfig.getSpec() == this.client.getSpec()) {
            ((AbstractConfiguration)this.clientConfig).watchers.forEach(AbstractConfiguration.ConfigWatcher::cacheLastValue);
        } else if (this.server != null && modConfig.getSpec() == this.server.getSpec()) {
            ((AbstractConfiguration)this.serverConfig).watchers.forEach(AbstractConfiguration.ConfigWatcher::cacheLastValue);
        } else if (this.common != null && modConfig.getSpec() == this.common.getSpec()) {
            ((AbstractConfiguration)this.commonConfig).watchers.forEach(AbstractConfiguration.ConfigWatcher::cacheLastValue);
        }
    }

    private void onConfigReload(ModConfig modConfig) {
        if (this.client != null && modConfig.getSpec() == this.client.getSpec()) {
            ((AbstractConfiguration)this.clientConfig).watchers.forEach(AbstractConfiguration.ConfigWatcher::compareAndFireChangeEvent);
        } else if (this.server != null && modConfig.getSpec() == this.server.getSpec()) {
            ((AbstractConfiguration)this.serverConfig).watchers.forEach(AbstractConfiguration.ConfigWatcher::compareAndFireChangeEvent);
        } else if (this.common != null && modConfig.getSpec() == this.common.getSpec()) {
            ((AbstractConfiguration)this.commonConfig).watchers.forEach(AbstractConfiguration.ConfigWatcher::compareAndFireChangeEvent);
        }
    }

    public <T> void set(ModConfigSpec.ConfigValue<T> configValue, T value) {
        configValue.set(value);
        configValue.save();
        this.onConfigValueEdit(configValue);
    }

    public void onConfigValueEdit(ModConfigSpec.ConfigValue<?> configValue) {
        for (AbstractConfiguration cfg : this.activeConfigs) {
            for (AbstractConfiguration.ConfigWatcher<?> configWatcher : cfg.watchers) {
                if (!configWatcher.isSameForgeConfig(configValue)) continue;
                configWatcher.compareAndFireChangeEvent();
            }
        }
    }

    @Deprecated(forRemoval=true, since="1.21")
    public Optional<ModConfigSpec.ValueSpec> getSpecFromValue(ModConfigSpec.ConfigValue<?> value) {
        return Optional.of(value.getSpec());
    }
}

