/*
 * Decompiled with CFR 0.152.
 */
package com.github.bigenergy.glassential.blocks.entity;

import com.github.bigenergy.glassential.blocks.ColorableGlassBlock;
import com.github.bigenergy.glassential.blocks.ColorableStainedGlassBlock;
import com.github.bigenergy.glassential.init.GlassentialBlockEntities;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColorableGlassBlockEntity
extends BlockEntity {
    private int color = 0xFFFFFF;
    private boolean emitLight = false;
    private boolean emitRedstone = false;
    private boolean passPlayer = false;
    private boolean passEntity = false;

    public ColorableGlassBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)GlassentialBlockEntities.COLORABLE_GLASS.get(), pPos, pBlockState);
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
        this.setChanged();
        if (this.level != null && !this.level.isClientSide) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 2);
            if (this.emitLight) {
                this.level.getChunkSource().getLightEngine().checkBlock(this.worldPosition);
            }
        }
    }

    public boolean getEmitLight() {
        return this.emitLight;
    }

    public void setEmitLight(boolean emitLight) {
        this.emitLight = emitLight;
        this.setChanged();
        if (this.level != null && !this.level.isClientSide) {
            BlockState currentState = this.getBlockState();
            if (currentState.hasProperty((Property)ColorableGlassBlock.LIT)) {
                this.level.setBlock(this.worldPosition, (BlockState)currentState.setValue((Property)ColorableGlassBlock.LIT, (Comparable)Boolean.valueOf(emitLight)), 3);
            } else if (currentState.hasProperty((Property)ColorableStainedGlassBlock.LIT)) {
                this.level.setBlock(this.worldPosition, (BlockState)currentState.setValue((Property)ColorableStainedGlassBlock.LIT, (Comparable)Boolean.valueOf(emitLight)), 3);
            }
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 2);
        }
    }

    public boolean getEmitRedstone() {
        return this.emitRedstone;
    }

    public void setEmitRedstone(boolean emitRedstone) {
        this.emitRedstone = emitRedstone;
        this.setChanged();
        if (this.level != null && !this.level.isClientSide) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 2);
        }
    }

    public boolean getPassPlayer() {
        return this.passPlayer;
    }

    public void setPassPlayer(boolean passPlayer) {
        this.passPlayer = passPlayer;
        this.setChanged();
        if (this.level != null && !this.level.isClientSide) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 2);
        }
    }

    public boolean getPassEntity() {
        return this.passEntity;
    }

    public void setPassEntity(boolean passEntity) {
        this.passEntity = passEntity;
        this.setChanged();
        if (this.level != null && !this.level.isClientSide) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 2);
        }
    }

    protected void saveAdditional(@NotNull CompoundTag pTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider pRegistries) {
        super.saveAdditional(pTag, pRegistries);
        pTag.putInt("Color", this.color);
        pTag.putBoolean("EmitLight", this.emitLight);
        pTag.putBoolean("EmitRedstone", this.emitRedstone);
        pTag.putBoolean("PassPlayer", this.passPlayer);
        pTag.putBoolean("PassEntity", this.passEntity);
    }

    protected void loadAdditional(@NotNull CompoundTag pTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider pRegistries) {
        super.loadAdditional(pTag, pRegistries);
        this.color = pTag.getInt("Color");
        this.emitLight = pTag.getBoolean("EmitLight");
        this.emitRedstone = pTag.getBoolean("EmitRedstone");
        this.passPlayer = pTag.getBoolean("PassPlayer");
        this.passEntity = pTag.getBoolean("PassEntity");
    }

    @NotNull
    public CompoundTag getUpdateTag(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider pRegistries) {
        CompoundTag tag = super.getUpdateTag(pRegistries);
        tag.putInt("Color", this.color);
        tag.putBoolean("EmitLight", this.emitLight);
        tag.putBoolean("EmitRedstone", this.emitRedstone);
        tag.putBoolean("PassPlayer", this.passPlayer);
        tag.putBoolean("PassEntity", this.passEntity);
        return tag;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider lookupProvider) {
        super.onDataPacket(net, pkt, lookupProvider);
        this.handleUpdateTag(pkt.getTag(), lookupProvider);
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        super.handleUpdateTag(tag, lookupProvider);
        if (tag.contains("Color")) {
            Minecraft mc;
            int oldColor = this.color;
            this.color = tag.getInt("Color");
            this.emitLight = tag.getBoolean("EmitLight");
            this.emitRedstone = tag.getBoolean("EmitRedstone");
            this.passPlayer = tag.getBoolean("PassPlayer");
            this.passEntity = tag.getBoolean("PassEntity");
            if (this.level != null && this.level.isClientSide && (mc = Minecraft.getInstance()) != null && mc.levelRenderer != null) {
                mc.levelRenderer.setBlocksDirty(this.worldPosition.getX(), this.worldPosition.getY(), this.worldPosition.getZ(), this.worldPosition.getX(), this.worldPosition.getY(), this.worldPosition.getZ());
            }
        }
    }
}

