/*
 * Decompiled with CFR 0.152.
 */
package fr.alasdiablo.mods.lib.api.data.loot;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootTable;
import org.jetbrains.annotations.NotNull;

public abstract class DioBlockLootSubProvider
extends BlockLootSubProvider {
    protected DioBlockLootSubProvider(Set<Item> pExplosionResistant, FeatureFlagSet pEnabledFeatures, HolderLookup.Provider pRegistries) {
        super(pExplosionResistant, pEnabledFeatures, pRegistries);
    }

    protected DioBlockLootSubProvider(Set<Item> pExplosionResistant, FeatureFlagSet pEnabledFeatures, Map<ResourceKey<LootTable>, LootTable.Builder> pMap, HolderLookup.Provider pRegistries) {
        super(pExplosionResistant, pEnabledFeatures, pMap, pRegistries);
    }

    public void generate(@NotNull BiConsumer<ResourceKey<LootTable>, LootTable.Builder> builder) {
        this.generate();
        HashSet<ResourceKey> set = new HashSet<ResourceKey>();
        for (Block block : this.getKnownBlocks()) {
            LootTable.Builder lootTableBuilder;
            ResourceKey resourceKey;
            if (!block.isEnabled(this.enabledFeatures) || (resourceKey = block.getLootTable()) == BuiltInLootTables.EMPTY || !set.add(resourceKey) || (lootTableBuilder = (LootTable.Builder)this.map.remove(resourceKey)) == null) continue;
            builder.accept((ResourceKey<LootTable>)resourceKey, lootTableBuilder);
        }
        if (!this.map.isEmpty()) {
            throw new IllegalStateException("Created block loot tables for non-blocks: " + String.valueOf(this.map.keySet()));
        }
    }
}

