/*
 * Decompiled with CFR 0.152.
 */
package fr.alasdiablo.mods.lib.api.data.blockstate;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import fr.alasdiablo.mods.lib.util.ImmutablePair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.client.model.generators.IGeneratedBlockState;
import org.jetbrains.annotations.NotNull;

public class DioMultipartBlockStateBuilder
implements IGeneratedBlockState {
    private final List<ImmutablePair<JsonObject, JsonObject>> multipart = new ArrayList<ImmutablePair<JsonObject, JsonObject>>();

    public void addMultipart(@NotNull ResourceLocation modelPathIn) {
        JsonObject apply = new JsonObject();
        apply.addProperty("model", modelPathIn.toString());
        this.multipart.add(new ImmutablePair<Object, JsonObject>(null, apply));
    }

    public void addMultipart(@NotNull ResourceLocation modelPathIn, boolean uvLockIn) {
        JsonObject apply = new JsonObject();
        apply.addProperty("model", modelPathIn.toString());
        if (uvLockIn) {
            apply.addProperty("uvlock", Boolean.valueOf(true));
        }
        this.multipart.add(new ImmutablePair<Object, JsonObject>(null, apply));
    }

    public void addMultipart(@NotNull ResourceLocation modelPathIn, boolean uvLockIn, int xIn, int yIn) {
        JsonObject apply = new JsonObject();
        apply.addProperty("model", modelPathIn.toString());
        if (uvLockIn) {
            apply.addProperty("uvlock", Boolean.valueOf(true));
        }
        if (xIn != 0) {
            apply.addProperty("x", (Number)xIn);
        }
        if (yIn != 0) {
            apply.addProperty("y", (Number)yIn);
        }
        this.multipart.add(new ImmutablePair<Object, JsonObject>(null, apply));
    }

    public void addMultipart(@NotNull ResourceLocation modelPathIn, boolean north, boolean east, boolean south, boolean west) {
        JsonObject when = new JsonObject();
        JsonObject apply = new JsonObject();
        this.handleCardinalPoint(when, north, east, south, west);
        apply.addProperty("model", modelPathIn.toString());
        this.multipart.add(new ImmutablePair<JsonObject, JsonObject>(when, apply));
    }

    public void addMultipart(@NotNull ResourceLocation modelPathIn, boolean uvLockIn, boolean north, boolean east, boolean south, boolean west) {
        JsonObject when = new JsonObject();
        JsonObject apply = new JsonObject();
        this.handleCardinalPoint(when, north, east, south, west);
        apply.addProperty("model", modelPathIn.toString());
        if (uvLockIn) {
            apply.addProperty("uvlock", Boolean.valueOf(true));
        }
        this.multipart.add(new ImmutablePair<JsonObject, JsonObject>(when, apply));
    }

    public void addMultipart(@NotNull ResourceLocation modelPathIn, boolean uvLockIn, int xIn, int yIn, boolean north, boolean east, boolean south, boolean west) {
        JsonObject when = new JsonObject();
        JsonObject apply = new JsonObject();
        this.handleCardinalPoint(when, north, east, south, west);
        apply.addProperty("model", modelPathIn.toString());
        if (uvLockIn) {
            apply.addProperty("uvlock", Boolean.valueOf(true));
        }
        if (xIn != 0) {
            apply.addProperty("x", (Number)xIn);
        }
        if (yIn != 0) {
            apply.addProperty("y", (Number)yIn);
        }
        this.multipart.add(new ImmutablePair<JsonObject, JsonObject>(when, apply));
    }

    private void handleCardinalPoint(JsonObject when, boolean north, boolean east, boolean south, boolean west) {
        if (north) {
            when.addProperty("north", Boolean.valueOf(true));
        }
        if (east) {
            when.addProperty("east", Boolean.valueOf(true));
        }
        if (south) {
            when.addProperty("south", Boolean.valueOf(true));
        }
        if (west) {
            when.addProperty("west", Boolean.valueOf(true));
        }
    }

    @NotNull
    public JsonObject toJson() {
        JsonArray multipartObj = new JsonArray();
        this.multipart.forEach(multipart -> {
            JsonObject object = new JsonObject();
            if (multipart.key() != null) {
                object.add("when", (JsonElement)multipart.key());
            }
            object.add("apply", (JsonElement)multipart.value());
            multipartObj.add((JsonElement)object);
        });
        JsonObject blockState = new JsonObject();
        blockState.add("multipart", (JsonElement)multipartObj);
        return blockState;
    }
}

