/*
 * Decompiled with CFR 0.152.
 */
package fr.alasdiablo.mods.lib.api.data.blockstate;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import fr.alasdiablo.mods.lib.api.data.blockstate.DioBlockStateVariant;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.client.model.generators.IGeneratedBlockState;
import org.jetbrains.annotations.NotNull;

public class DioBlockStateBuilder
implements IGeneratedBlockState {
    private final Map<String, JsonObject> variants = new HashMap<String, JsonObject>();

    public void addVariants(@NotNull String stateNameIn, int rotateXIn, int rotateYIn, boolean uvlock, @NotNull ResourceLocation modelPathIn) {
        JsonObject variant = new JsonObject();
        variant.addProperty("model", modelPathIn.toString());
        if (rotateXIn != 0) {
            variant.addProperty("x", (Number)rotateXIn);
        }
        if (rotateYIn != 0) {
            variant.addProperty("y", (Number)rotateYIn);
        }
        if (uvlock) {
            variant.addProperty("uvlock", Boolean.valueOf(true));
        }
        this.variants.put(stateNameIn, variant);
    }

    public void addVariants(@NotNull String stateNameIn, int rotateXIn, int rotateYIn, @NotNull ResourceLocation modelPathIn) {
        this.addVariants(stateNameIn, rotateXIn, rotateYIn, false, modelPathIn);
    }

    public void addVariants(String stateNameIn, @NotNull ResourceLocation modelPathIn) {
        this.addVariants(stateNameIn, 0, 0, false, modelPathIn);
    }

    public void addVariants(@NotNull DioBlockStateVariant variant) {
        this.variants.put(variant.key(), variant.json());
    }

    @NotNull
    public JsonObject toJson() {
        JsonObject blockStateVariants = new JsonObject();
        this.variants.forEach((arg_0, arg_1) -> ((JsonObject)blockStateVariants).add(arg_0, arg_1));
        JsonObject blockState = new JsonObject();
        blockState.add("variants", (JsonElement)blockStateVariants);
        return blockState;
    }
}

