/*
 * Decompiled with CFR 0.152.
 */
package fr.alasdiablo.mods.lib.api.config;

import fr.alasdiablo.mods.lib.Constants;
import fr.alasdiablo.mods.lib.api.config.DuplicatedJsonConfigException;
import fr.alasdiablo.mods.lib.api.config.JsonConfig;
import fr.alasdiablo.mods.lib.platform.Services;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class JsonConfigBuilder {
    private static final List<String> modIDList = new ArrayList<String>();
    private final Map<String, JsonConfig> jsonConfigs;
    private final String modID;
    private final List<String> configDir;

    public JsonConfigBuilder(String modID) throws DuplicatedJsonConfigException {
        this.modID = modID;
        if (modIDList.contains(this.modID)) {
            throw new DuplicatedJsonConfigException(this.modID);
        }
        this.jsonConfigs = new HashMap<String, JsonConfig>();
        this.configDir = Collections.singletonList(modID);
    }

    public JsonConfigBuilder(String modID, String ... configSubDir) throws DuplicatedJsonConfigException {
        this.modID = modID + "/" + String.join((CharSequence)"/", configSubDir);
        if (modIDList.contains(this.modID)) {
            throw new DuplicatedJsonConfigException(this.modID);
        }
        this.jsonConfigs = new HashMap<String, JsonConfig>();
        ArrayList<String> path = new ArrayList<String>(Collections.singletonList(modID));
        path.addAll(Arrays.asList(configSubDir));
        this.configDir = path;
    }

    public JsonConfigBuilder add(@NotNull JsonConfig jsonConfig) throws DuplicatedJsonConfigException {
        if (this.jsonConfigs.containsKey(jsonConfig.getName())) {
            throw new DuplicatedJsonConfigException(jsonConfig.getName(), this.modID);
        }
        this.jsonConfigs.put(jsonConfig.getName(), jsonConfig);
        return this;
    }

    public void build() throws IOException {
        String currentPath = Services.PLATFORM.getConfigPath();
        Path path = null;
        for (String e2 : this.configDir) {
            Path tmpPath = Paths.get(currentPath, e2);
            currentPath = tmpPath.toString();
            try {
                path = Files.createDirectory(tmpPath, new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException exception) {
                path = tmpPath;
            }
            Constants.LOG.debug("Create folder: {}", (Object)path);
        }
        modIDList.add(this.modID);
        Path finalPath = path;
        this.jsonConfigs.values().forEach(e -> {
            assert (finalPath != null);
            e.filePath(Paths.get(finalPath.toString(), e.getName() + ".json"));
        });
        for (JsonConfig e3 : this.jsonConfigs.values()) {
            e3.initOrLoad();
        }
    }
}

