/*
 * Decompiled with CFR 0.152.
 */
package fr.alasdiablo.mods.lib.api.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonWriter;
import fr.alasdiablo.mods.lib.Constants;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;

public abstract class JsonConfig {
    private Path filePath = null;

    void initOrLoad() throws IOException, IllegalStateException {
        if (this.filePath == null) {
            throw new IllegalStateException("File path of " + this.getName() + " is null !");
        }
        try {
            FileReader fileReader = new FileReader(this.filePath.toString());
            JsonObject json = JsonParser.parseReader((Reader)fileReader).getAsJsonObject();
            this.read(json);
            fileReader.close();
            Constants.LOG.debug(String.format("Config %s have been loaded", this.getName()));
        }
        catch (FileNotFoundException e) {
            this.preWrite();
            Constants.LOG.debug(String.format("Config %s have been write and loaded", this.getName()));
        }
        catch (JsonParseException | IllegalArgumentException | NullPointerException e) {
            Constants.LOG.warn(String.format("Error during config initialization on %s cause by: %s", this.getName(), e.getLocalizedMessage()));
            this.preWrite();
            Constants.LOG.debug(String.format("Config %s have been rewrite and loaded", this.getName()));
        }
    }

    private void postWrite(@NotNull JsonObject json) throws IOException {
        FileWriter fileWriter = new FileWriter(this.filePath.toString());
        StringWriter stringWriter = new StringWriter();
        JsonWriter jsonWriter = new JsonWriter((Writer)stringWriter);
        jsonWriter.setLenient(true);
        jsonWriter.setIndent("  ");
        Streams.write((JsonElement)json, (JsonWriter)jsonWriter);
        fileWriter.write(stringWriter.toString());
        fileWriter.flush();
        fileWriter.close();
    }

    private void preWrite() throws IOException, IllegalStateException {
        if (this.filePath == null) {
            throw new IllegalStateException("File path of " + this.getName() + " is null !");
        }
        JsonObject json = this.write();
        this.postWrite(json);
    }

    protected abstract void read(JsonObject var1);

    protected abstract JsonObject write();

    protected abstract String getName();

    void filePath(Path path) {
        this.filePath = path;
    }
}

