/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.sdlink.shaded.oshi.util.platform.mac;

import com.hypherionmc.sdlink.shaded.oshi.annotation.concurrent.ThreadSafe;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.platform.mac.SystemB;
import com.sun.jna.platform.unix.LibCAPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class SysctlUtil {
    private static final Logger LOG = LoggerFactory.getLogger(SysctlUtil.class);
    private static final String SYSCTL_FAIL = "Failed sysctl call: {}, Error code: {}";

    private SysctlUtil() {
    }

    public static int sysctl(String name, int def) {
        LibCAPI.size_t.ByReference size = new LibCAPI.size_t.ByReference((long)SystemB.INT_SIZE);
        Memory p = new Memory(size.longValue());
        if (0 != com.hypherionmc.sdlink.shaded.oshi.jna.platform.mac.SystemB.INSTANCE.sysctlbyname(name, (Pointer)p, size, null, LibCAPI.size_t.ZERO)) {
            LOG.warn(SYSCTL_FAIL, (Object)name, (Object)Native.getLastError());
            return def;
        }
        return p.getInt(0L);
    }

    public static long sysctl(String name, long def) {
        LibCAPI.size_t.ByReference size = new LibCAPI.size_t.ByReference((long)SystemB.UINT64_SIZE);
        Memory p = new Memory(size.longValue());
        if (0 != com.hypherionmc.sdlink.shaded.oshi.jna.platform.mac.SystemB.INSTANCE.sysctlbyname(name, (Pointer)p, size, null, LibCAPI.size_t.ZERO)) {
            LOG.error(SYSCTL_FAIL, (Object)name, (Object)Native.getLastError());
            return def;
        }
        return p.getLong(0L);
    }

    public static String sysctl(String name, String def) {
        LibCAPI.size_t.ByReference size = new LibCAPI.size_t.ByReference();
        if (0 != com.hypherionmc.sdlink.shaded.oshi.jna.platform.mac.SystemB.INSTANCE.sysctlbyname(name, null, size, null, LibCAPI.size_t.ZERO)) {
            LOG.error(SYSCTL_FAIL, (Object)name, (Object)Native.getLastError());
            return def;
        }
        Memory p = new Memory(size.longValue() + 1L);
        if (0 != com.hypherionmc.sdlink.shaded.oshi.jna.platform.mac.SystemB.INSTANCE.sysctlbyname(name, (Pointer)p, size, null, LibCAPI.size_t.ZERO)) {
            LOG.error(SYSCTL_FAIL, (Object)name, (Object)Native.getLastError());
            return def;
        }
        return p.getString(0L);
    }

    public static boolean sysctl(String name, Structure struct) {
        if (0 != com.hypherionmc.sdlink.shaded.oshi.jna.platform.mac.SystemB.INSTANCE.sysctlbyname(name, struct.getPointer(), new LibCAPI.size_t.ByReference((long)struct.size()), null, LibCAPI.size_t.ZERO)) {
            LOG.error(SYSCTL_FAIL, (Object)name, (Object)Native.getLastError());
            return false;
        }
        struct.read();
        return true;
    }

    public static Memory sysctl(String name) {
        LibCAPI.size_t.ByReference size = new LibCAPI.size_t.ByReference();
        if (0 != com.hypherionmc.sdlink.shaded.oshi.jna.platform.mac.SystemB.INSTANCE.sysctlbyname(name, null, size, null, LibCAPI.size_t.ZERO)) {
            LOG.error(SYSCTL_FAIL, (Object)name, (Object)Native.getLastError());
            return null;
        }
        Memory m = new Memory(size.longValue());
        if (0 != com.hypherionmc.sdlink.shaded.oshi.jna.platform.mac.SystemB.INSTANCE.sysctlbyname(name, (Pointer)m, size, null, LibCAPI.size_t.ZERO)) {
            LOG.error(SYSCTL_FAIL, (Object)name, (Object)Native.getLastError());
            return null;
        }
        return m;
    }
}

