/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.luggage.network;

import com.gizmo.luggage.entity.AbstractLuggage;
import io.netty.buffer.ByteBuf;
import java.util.Iterator;
import java.util.List;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class SitNearbyLuggagesPacket
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<SitNearbyLuggagesPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"luggage", (String)"sit_nearby_luggage"));
    public static final SitNearbyLuggagesPacket INSTANCE = new SitNearbyLuggagesPacket();
    public static final StreamCodec<ByteBuf, SitNearbyLuggagesPacket> STREAM_CODEC = StreamCodec.unit((Object)INSTANCE);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Player player = ctx.player();
            List nearbyOwnedLuggages = player.level().getEntitiesOfClass(AbstractLuggage.class, player.getBoundingBox().inflate(8.0), entity -> entity.getOwner() == player);
            if (!nearbyOwnedLuggages.isEmpty()) {
                Iterator iterator = nearbyOwnedLuggages.iterator();
                while (iterator.hasNext()) {
                    AbstractLuggage luggage;
                    luggage.setInSittingPose(!(luggage = (AbstractLuggage)((Object)((Object)iterator.next()))).isInSittingPose());
                }
            }
        });
    }
}

