/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.luggage.client;

import com.gizmo.luggage.LuggageRegistries;
import com.gizmo.luggage.client.EntityCache;
import com.gizmo.luggage.item.AbstractLuggageItem;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class LuggageItemRenderer
extends BlockEntityWithoutLevelRenderer {
    public LuggageItemRenderer() {
        super(Minecraft.getInstance().getBlockEntityRenderDispatcher(), Minecraft.getInstance().getEntityModels());
    }

    public void renderByItem(ItemStack stack, ItemDisplayContext context, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        AbstractLuggageItem luggage;
        LivingEntity entity;
        Item item = stack.getItem();
        if (item instanceof AbstractLuggageItem && (entity = EntityCache.fetchEntity((luggage = (AbstractLuggageItem)item).getLuggage().get(), (Level)Minecraft.getInstance().level, stack.has(LuggageRegistries.EXTENDED))) != null) {
            this.renderEntity((Entity)entity, context, ms, light);
        }
    }

    private void renderEntity(Entity entity, ItemDisplayContext context, PoseStack stack, int light) {
        float partialTicks = Minecraft.getInstance().getTimer().getGameTimeDeltaTicks();
        float partialTicksForRender = Minecraft.getInstance().isPaused() ? 0.0f : partialTicks;
        stack.scale(-1.0f, -1.0f, 1.0f);
        stack.translate(-0.5f, -0.2f, 0.0f);
        stack.scale(0.8f, 0.8f, 0.8f);
        stack.mulPose(Axis.ZP.rotationDegrees(180.0f));
        EntityRenderDispatcher dispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
        boolean hitboxes = dispatcher.shouldRenderHitBoxes();
        dispatcher.setRenderShadow(false);
        dispatcher.setRenderHitBoxes(false);
        MultiBufferSource.BufferSource source = Minecraft.getInstance().renderBuffers().bufferSource();
        RenderSystem.runAsFancy(() -> dispatcher.render(entity, 0.0, 0.0, 0.0, 0.0f, partialTicksForRender, stack, (MultiBufferSource)source, context == ItemDisplayContext.GUI ? 0xF000F0 : light));
        source.endBatch();
        dispatcher.setRenderShadow(true);
        dispatcher.setRenderHitBoxes(hitboxes);
    }
}

