/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.luggage;

import com.gizmo.luggage.entity.EnderLuggage;
import com.gizmo.luggage.entity.Luggage;
import com.gizmo.luggage.item.AbstractLuggageItem;
import com.gizmo.luggage.item.LuggageItem;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class LuggageRegistries {
    public static final DeferredRegister<DataComponentType<?>> COMPONENTS = DeferredRegister.createDataComponents((String)"luggage");
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"luggage");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((ResourceKey)Registries.ITEM, (String)"luggage");
    public static final DeferredRegister<SoundEvent> SOUNDS = DeferredRegister.create((ResourceKey)Registries.SOUND_EVENT, (String)"luggage");
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Unit>> EXTENDED = COMPONENTS.register("extended", () -> DataComponentType.builder().persistent(Unit.CODEC).networkSynchronized(StreamCodec.unit((Object)Unit.INSTANCE)).build());
    public static final DeferredHolder<EntityType<?>, EntityType<Luggage>> LUGGAGE = ENTITIES.register("luggage", () -> EntityType.Builder.of(Luggage::new, (MobCategory)MobCategory.CREATURE).fireImmune().sized(0.75f, 0.75f).build("luggage:luggage"));
    public static final DeferredHolder<EntityType<?>, EntityType<EnderLuggage>> ENDER_LUGGAGE = ENTITIES.register("ender_luggage", () -> EntityType.Builder.of(EnderLuggage::new, (MobCategory)MobCategory.CREATURE).fireImmune().sized(0.75f, 0.75f).build("luggage:ender_luggage"));
    public static final DeferredHolder<Item, Item> LUGGAGE_ITEM = ITEMS.register("luggage", () -> new LuggageItem(new Item.Properties().fireResistant().stacksTo(1)));
    public static final DeferredHolder<Item, Item> ENDER_LUGGAGE_ITEM = ITEMS.register("ender_luggage", () -> new AbstractLuggageItem(ENDER_LUGGAGE, new Item.Properties().fireResistant().stacksTo(1)));
    public static final DeferredHolder<SoundEvent, SoundEvent> LUGGAGE_KILLED = LuggageRegistries.createEvent("entity.luggage.luggage.killed");
    public static final DeferredHolder<SoundEvent, SoundEvent> LUGGAGE_EAT_FOOD = LuggageRegistries.createEvent("entity.luggage.luggage.eat_food");
    public static final DeferredHolder<SoundEvent, SoundEvent> LUGGAGE_EAT_ITEM = LuggageRegistries.createEvent("entity.luggage.luggage.eat_item");
    public static final DeferredHolder<SoundEvent, SoundEvent> LUGGAGE_STEP = LuggageRegistries.createEvent("entity.luggage.luggage.step");
    public static final DeferredHolder<SoundEvent, SoundEvent> WHISTLE_CALL = LuggageRegistries.createEvent("entity.luggage.player.whistle_call");
    public static final DeferredHolder<SoundEvent, SoundEvent> WHISTLE_WAIT = LuggageRegistries.createEvent("entity.luggage.player.whistle_wait");

    private static DeferredHolder<SoundEvent, SoundEvent> createEvent(String sound) {
        ResourceLocation name = ResourceLocation.fromNamespaceAndPath((String)"luggage", (String)sound);
        return SOUNDS.register(sound, () -> SoundEvent.createVariableRangeEvent((ResourceLocation)name));
    }
}

