/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.inworldrecipes.event;

import com.benbenlaw.core.recipe.NoInventoryRecipe;
import com.benbenlaw.inworldrecipes.recipes.BlockConversionRecipe;
import com.benbenlaw.inworldrecipes.recipes.DropItemInFluidConvertsFluidRecipe;
import com.benbenlaw.inworldrecipes.recipes.DropItemInFluidRecipe;
import com.benbenlaw.inworldrecipes.recipes.RightClickOnBlockTransformsBlockRecipe;
import com.benbenlaw.inworldrecipes.recipes.RightClickOnBlockTransformsItemRecipe;
import com.benbenlaw.inworldrecipes.recipes.RightClickOnEntityTransformsItemRecipe;
import com.benbenlaw.inworldrecipes.util.DimensionPositionHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.EnderDragonPart;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.dimension.end.EndDragonFight;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;

@EventBusSubscriber(modid="inworldrecipes")
public class InWorldRecipeEvents {
    private static final Map<DimensionPositionHelper, Long> placedBlocks = new HashMap<DimensionPositionHelper, Long>();

    @SubscribeEvent
    public static void rightClickOnBlock(PlayerInteractEvent.RightClickBlock event) {
        Level level = event.getLevel();
        Player player = event.getEntity();
        InteractionHand hand = event.getHand();
        if (!level.isClientSide()) {
            boolean correctBlock;
            boolean correctAmountOfItems;
            boolean correctItems;
            ItemStack heldItemPlayer = event.getItemStack();
            BlockPos blockPos = event.getPos();
            Block targetBlockPlayer = level.getBlockState(blockPos).getBlock();
            for (RecipeHolder match : level.getRecipeManager().getRecipesFor((RecipeType)RightClickOnBlockTransformsBlockRecipe.Type.INSTANCE, (RecipeInput)NoInventoryRecipe.INSTANCE, level)) {
                correctItems = ((RightClickOnBlockTransformsBlockRecipe)match.value()).heldItem().test(heldItemPlayer);
                correctAmountOfItems = heldItemPlayer.getCount() >= ((RightClickOnBlockTransformsBlockRecipe)match.value()).heldItem().count();
                correctBlock = ((RightClickOnBlockTransformsBlockRecipe)match.value()).targetBlock().test(targetBlockPlayer.asItem().getDefaultInstance());
                Block newBlock = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)((RightClickOnBlockTransformsBlockRecipe)match.value()).newBlock()));
                Fluid newBlockAsFluid = (Fluid)BuiltInRegistries.FLUID.get(ResourceLocation.parse((String)((RightClickOnBlockTransformsBlockRecipe)match.value()).newBlock()));
                if (!correctItems || !correctBlock || !correctAmountOfItems) continue;
                if (newBlock != Blocks.AIR) {
                    level.setBlockAndUpdate(blockPos, newBlock.defaultBlockState());
                } else {
                    level.setBlockAndUpdate(blockPos, newBlock.defaultBlockState());
                }
                SoundType blockSounds = newBlock.getSoundType(newBlock.defaultBlockState(), (LevelReader)level, blockPos, null);
                level.playSound(null, blockPos, blockSounds.getPlaceSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
                player.swing(hand, true);
                if (((RightClickOnBlockTransformsBlockRecipe)match.value()).damageHeldItem()) {
                    EquipmentSlot equipmentSlot = hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND;
                    heldItemPlayer.hurtAndBreak(1, (LivingEntity)player, equipmentSlot);
                }
                if (((RightClickOnBlockTransformsBlockRecipe)match.value()).consumeHeldItem()) {
                    heldItemPlayer.shrink(((RightClickOnBlockTransformsBlockRecipe)match.value()).heldItem().count());
                }
                event.setCanceled(true);
                break;
            }
            for (RecipeHolder match : level.getRecipeManager().getRecipesFor((RecipeType)RightClickOnBlockTransformsItemRecipe.Type.INSTANCE, (RecipeInput)NoInventoryRecipe.INSTANCE, level)) {
                correctItems = ((RightClickOnBlockTransformsItemRecipe)match.value()).heldItem().test(heldItemPlayer);
                correctAmountOfItems = heldItemPlayer.getCount() >= ((RightClickOnBlockTransformsItemRecipe)match.value()).heldItem().count();
                correctBlock = ((RightClickOnBlockTransformsItemRecipe)match.value()).targetBlock().test(targetBlockPlayer.asItem().getDefaultInstance());
                boolean destroyTargetBlock = ((RightClickOnBlockTransformsItemRecipe)match.value()).destroyTargetBlock();
                boolean popItem = ((RightClickOnBlockTransformsItemRecipe)match.value()).popItem();
                boolean consumeHeldItem = ((RightClickOnBlockTransformsItemRecipe)match.value()).consumeHeldItem();
                List<ItemStack> resultItem = ((RightClickOnBlockTransformsItemRecipe)match.value()).rollResults(level.random);
                if (!correctItems || !correctBlock || !correctAmountOfItems) continue;
                if (destroyTargetBlock) {
                    level.setBlockAndUpdate(blockPos, Blocks.AIR.defaultBlockState());
                }
                if (popItem) {
                    for (ItemStack itemStack : resultItem) {
                        InWorldRecipeEvents.popOutTheItem(level, blockPos, itemStack);
                    }
                } else {
                    for (ItemStack itemStack : resultItem) {
                        player.addItem(itemStack);
                    }
                }
                if (consumeHeldItem) {
                    heldItemPlayer.shrink(((RightClickOnBlockTransformsItemRecipe)match.value()).heldItem().count());
                }
                if (((RightClickOnBlockTransformsItemRecipe)match.value()).damageHeldItem()) {
                    EquipmentSlot equipmentSlot = hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND;
                    heldItemPlayer.hurtAndBreak(1, (LivingEntity)player, equipmentSlot);
                }
                player.swing(hand, true);
                event.setCanceled(true);
                break;
            }
        }
    }

    @SubscribeEvent
    public static void onItemEntityTick(EntityTickEvent.Pre event) {
        Level level = event.getEntity().level();
        if (!level.isClientSide() && event.getEntity() instanceof ItemEntity) {
            BlockPos fluidPos = event.getEntity().blockPosition();
            for (RecipeHolder match : level.getRecipeManager().getRecipesFor((RecipeType)DropItemInFluidRecipe.Type.INSTANCE, (RecipeInput)NoInventoryRecipe.INSTANCE, level)) {
                DropItemInFluidRecipe recipe = (DropItemInFluidRecipe)match.value();
                Fluid requiredFluid = (Fluid)BuiltInRegistries.FLUID.get(ResourceLocation.tryParse((String)recipe.fluid()));
                boolean correctFluid = level.getFluidState(fluidPos).is(requiredFluid);
                if (!correctFluid) continue;
                boolean consumeFluid = recipe.consumeFluidBlock();
                NonNullList<SizedIngredient> ingredients = recipe.getDroppedItems();
                List itemEntities = level.getEntitiesOfClass(ItemEntity.class, new AABB(fluidPos).inflate(0.5), entity -> entity.isAlive() && !entity.getItem().isEmpty());
                ArrayList<ItemEntity> matchedEntities = new ArrayList<ItemEntity>();
                boolean allIngredientsMatched = true;
                for (Object ingredient : ingredients) {
                    boolean matched = false;
                    for (ItemEntity itemEntity : itemEntities) {
                        ItemStack stack = itemEntity.getItem();
                        if (matchedEntities.contains(itemEntity) || !ingredient.test(stack) || stack.getCount() < ingredient.count()) continue;
                        matchedEntities.add(itemEntity);
                        matched = true;
                        break;
                    }
                    if (matched) continue;
                    allIngredientsMatched = false;
                    break;
                }
                if (!allIngredientsMatched) continue;
                List<ItemStack> resultItems = recipe.rollResults(level.random);
                for (ItemStack itemStack : resultItems) {
                    ItemEntity outputEntity = new ItemEntity(level, (double)fluidPos.getX() + 0.5, (double)(fluidPos.getY() + 1), (double)fluidPos.getZ() + 0.5, itemStack);
                    outputEntity.setDefaultPickUpDelay();
                    level.addFreshEntity((Entity)outputEntity);
                }
                for (int i = 0; i < ingredients.size(); ++i) {
                    SizedIngredient ingredient = (SizedIngredient)ingredients.get(i);
                    ItemEntity itemEntity = (ItemEntity)matchedEntities.get(i);
                    itemEntity.getItem().shrink(ingredient.count());
                }
                if (!consumeFluid) break;
                level.setBlockAndUpdate(fluidPos, Blocks.AIR.defaultBlockState());
                break;
            }
            for (RecipeHolder match : level.getRecipeManager().getRecipesFor((RecipeType)DropItemInFluidConvertsFluidRecipe.Type.INSTANCE, (RecipeInput)NoInventoryRecipe.INSTANCE, level)) {
                boolean correctItem = ((DropItemInFluidConvertsFluidRecipe)match.value()).droppedItem().test(((ItemEntity)event.getEntity()).getItem());
                int requiredAmount = ((DropItemInFluidConvertsFluidRecipe)match.value()).droppedItem().count();
                ItemEntity itemEntity = (ItemEntity)event.getEntity();
                ItemStack itemStack = itemEntity.getItem();
                boolean correctItemAmount = itemStack.getCount() >= requiredAmount;
                boolean destroyItems = ((DropItemInFluidConvertsFluidRecipe)match.value()).destroyItems();
                Fluid fluid = (Fluid)BuiltInRegistries.FLUID.get(ResourceLocation.tryParse((String)((DropItemInFluidConvertsFluidRecipe)match.value()).fluid()));
                boolean correctFluid = level.getFluidState(event.getEntity().getOnPos()).is(fluid);
                Fluid newFluid = (Fluid)BuiltInRegistries.FLUID.get(ResourceLocation.tryParse((String)((DropItemInFluidConvertsFluidRecipe)match.value()).newFluid()));
                if (!correctItem || !correctFluid || !correctItemAmount) continue;
                level.setBlockAndUpdate(event.getEntity().blockPosition(), newFluid.defaultFluidState().createLegacyBlock());
                if (!destroyItems) break;
                itemStack.shrink(requiredAmount);
                break;
            }
        }
    }

    @SubscribeEvent
    public static void onEntityRightClick(PlayerInteractEvent.EntityInteractSpecific event) {
        Level level = event.getLevel();
        Player player = event.getEntity();
        Entity entity = event.getTarget();
        InteractionHand hand = event.getHand();
        if (!level.isClientSide()) {
            ItemStack heldItemPlayer = event.getItemStack();
            for (RecipeHolder match : level.getRecipeManager().getRecipesFor((RecipeType)RightClickOnEntityTransformsItemRecipe.Type.INSTANCE, (RecipeInput)NoInventoryRecipe.INSTANCE, level)) {
                Entity targetEntity = ((EntityType)BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.tryParse((String)((RightClickOnEntityTransformsItemRecipe)match.value()).entity()))).create(level);
                assert (targetEntity != null);
                boolean correctEntity = entity.getType() == targetEntity.getType();
                boolean correctItems = ((RightClickOnEntityTransformsItemRecipe)match.value()).heldItem().test(player.getItemInHand(event.getHand()));
                boolean correctAmountOfItems = player.getItemInHand(event.getHand()).getCount() >= ((RightClickOnEntityTransformsItemRecipe)match.value()).heldItem().count();
                boolean damageHeldItem = ((RightClickOnEntityTransformsItemRecipe)match.value()).damageHeldItem();
                boolean consumeHeldItem = ((RightClickOnEntityTransformsItemRecipe)match.value()).consumeHeldItem();
                boolean destroyEntity = ((RightClickOnEntityTransformsItemRecipe)match.value()).destroyEntity();
                boolean popItem = ((RightClickOnEntityTransformsItemRecipe)match.value()).popItem();
                List<ItemStack> resultItem = ((RightClickOnEntityTransformsItemRecipe)match.value()).rollResults(level.random);
                if (!correctEntity || !correctItems || !correctAmountOfItems) continue;
                if (destroyEntity) {
                    ServerLevel serverLevel;
                    EndDragonFight fight;
                    EnderDragon dragon;
                    if (entity instanceof EnderDragonPart) {
                        EnderDragonPart part = (EnderDragonPart)entity;
                        entity = part.parentMob;
                    }
                    if (entity instanceof EnderDragon && (dragon = (EnderDragon)entity).level().getServer() != null && (fight = (serverLevel = (ServerLevel)dragon.level()).getDragonFight()) != null) {
                        fight.setDragonKilled(dragon);
                    }
                    entity.remove(Entity.RemovalReason.KILLED);
                }
                if (damageHeldItem) {
                    EquipmentSlot equipmentSlot = hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND;
                    heldItemPlayer.hurtAndBreak(1, (LivingEntity)player, equipmentSlot);
                }
                if (consumeHeldItem) {
                    player.getItemInHand(event.getHand()).shrink(((RightClickOnEntityTransformsItemRecipe)match.value()).heldItem().count());
                }
                if (popItem) {
                    for (ItemStack itemStack : resultItem) {
                        InWorldRecipeEvents.popOutTheItem(level, entity.blockPosition(), itemStack);
                    }
                } else {
                    for (ItemStack itemStack : resultItem) {
                        player.addItem(itemStack);
                    }
                }
                player.swing(hand, true);
                event.setCanceled(true);
                break;
            }
        }
    }

    @SubscribeEvent
    public static void onBlockConversion(BlockEvent.EntityPlaceEvent event) {
        Level level = Objects.requireNonNull(event.getEntity()).level();
        Block block = event.getPlacedBlock().getBlock();
        for (RecipeHolder match : level.getRecipeManager().getRecipesFor((RecipeType)BlockConversionRecipe.Type.INSTANCE, (RecipeInput)NoInventoryRecipe.INSTANCE, level)) {
            DimensionPositionHelper dimensionPositionHelper;
            ServerLevel serverLevel;
            Block recipeBlock = ((BlockConversionRecipe)match.value()).getBlockToConvert();
            TagKey<Block> recipeBlockTag = ((BlockConversionRecipe)match.value()).getBlockToConvertTag();
            if (recipeBlock != null && block == recipeBlock && level instanceof ServerLevel) {
                serverLevel = (ServerLevel)level;
                dimensionPositionHelper = new DimensionPositionHelper((ResourceKey<Level>)serverLevel.dimension(), event.getPos());
                placedBlocks.put(dimensionPositionHelper, level.getGameTime());
            }
            if (recipeBlockTag == null || !block.defaultBlockState().is(recipeBlockTag) || !(level instanceof ServerLevel)) continue;
            serverLevel = (ServerLevel)level;
            dimensionPositionHelper = new DimensionPositionHelper((ResourceKey<Level>)serverLevel.dimension(), event.getPos());
            placedBlocks.put(dimensionPositionHelper, level.getGameTime());
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        Level level = event.getPlayer().level();
        Block block = event.getState().getBlock();
        for (RecipeHolder match : level.getRecipeManager().getRecipesFor((RecipeType)BlockConversionRecipe.Type.INSTANCE, (RecipeInput)NoInventoryRecipe.INSTANCE, level)) {
            DimensionPositionHelper dimensionPositionHelper;
            ServerLevel serverLevel;
            Block recipeBlock = ((BlockConversionRecipe)match.value()).getBlockToConvert();
            TagKey<Block> recipeBlockTag = ((BlockConversionRecipe)match.value()).getBlockToConvertTag();
            if (recipeBlock != null && block == recipeBlock && level instanceof ServerLevel) {
                serverLevel = (ServerLevel)level;
                dimensionPositionHelper = new DimensionPositionHelper((ResourceKey<Level>)serverLevel.dimension(), event.getPos());
                placedBlocks.remove(dimensionPositionHelper);
            }
            if (recipeBlockTag == null || !block.defaultBlockState().is(recipeBlockTag) || !(level instanceof ServerLevel)) continue;
            serverLevel = (ServerLevel)level;
            dimensionPositionHelper = new DimensionPositionHelper((ResourceKey<Level>)serverLevel.dimension(), event.getPos());
            placedBlocks.remove(dimensionPositionHelper);
        }
    }

    @SubscribeEvent
    public static void onServerTick(ServerTickEvent.Post event) {
        Iterator<Map.Entry<DimensionPositionHelper, Long>> iterator = placedBlocks.entrySet().iterator();
        block0: while (iterator.hasNext()) {
            Map.Entry<DimensionPositionHelper, Long> entry = iterator.next();
            DimensionPositionHelper dimensionPositionHelper = entry.getKey();
            ServerLevel level = event.getServer().getLevel(dimensionPositionHelper.dimension());
            assert (level != null);
            long currentTime = level.getGameTime();
            String dimension = dimensionPositionHelper.dimension().location().toString();
            if (!dimensionPositionHelper.dimension().equals((Object)level.dimension())) continue;
            BlockPos pos = dimensionPositionHelper.pos();
            long placedTime = entry.getValue();
            if (!level.isLoaded(pos)) continue;
            BlockState state = level.getBlockState(pos);
            for (RecipeHolder match : level.getRecipeManager().getRecipesFor((RecipeType)BlockConversionRecipe.Type.INSTANCE, (RecipeInput)NoInventoryRecipe.INSTANCE, (Level)level)) {
                boolean requiresDimension;
                boolean requiresMoonlight;
                boolean requiresSunlight;
                Block recipeBlock = ((BlockConversionRecipe)match.value()).getBlockToConvert();
                TagKey<Block> recipeBlockTag = ((BlockConversionRecipe)match.value()).getBlockToConvertTag();
                Block convertedBlock = ((BlockConversionRecipe)match.value()).getConvertedBlock();
                int duration = ((BlockConversionRecipe)match.value()).duration();
                boolean popItem = ((BlockConversionRecipe)match.value()).popBlock();
                assert (recipeBlock != null);
                if (!state.is(recipeBlock) && (recipeBlockTag == null || !state.is(recipeBlockTag)) || currentTime - placedTime < (long)duration || (requiresSunlight = ((BlockConversionRecipe)match.value()).requiresSunlight()) && (!level.canSeeSky(pos.above()) || !level.isDay()) || (requiresMoonlight = ((BlockConversionRecipe)match.value()).requiresMoonlight()) && (!level.canSeeSky(pos.above()) || level.isDay())) continue;
                String requiredDimension = ((BlockConversionRecipe)match.value()).dimension();
                boolean bl = requiresDimension = !requiredDimension.contains("none");
                if (requiresDimension && !dimension.equals(requiredDimension)) continue;
                if (popItem) {
                    InWorldRecipeEvents.popOutTheItem((Level)level, pos, new ItemStack((ItemLike)convertedBlock));
                    level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
                } else {
                    level.setBlockAndUpdate(pos, convertedBlock.defaultBlockState());
                }
                SoundType blockSounds = convertedBlock.getSoundType(convertedBlock.defaultBlockState(), (LevelReader)level, pos, null);
                level.playSound(null, pos, blockSounds.getPlaceSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
                iterator.remove();
                continue block0;
            }
        }
    }

    public static void popOutTheItem(Level level, BlockPos blockPos, ItemStack itemStack) {
        Vec3 vec3 = Vec3.atLowerCornerWithOffset((Vec3i)blockPos, (double)0.5, (double)1.1, (double)0.5).offsetRandom(level.random, 0.7f);
        ItemStack itemstack1 = itemStack.copy();
        ItemEntity itementity = new ItemEntity(level, vec3.x(), vec3.y(), vec3.z(), itemstack1);
        itementity.setDefaultPickUpDelay();
        level.addFreshEntity((Entity)itementity);
    }
}

